/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.io.File;
import org.esa.snap.binning.reader.BinnedFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinnedFileFilterTest {
    private static final String endsWith = ".nc";
    private BinnedFileFilter filter;

    @Before
    public void setUp() throws Exception {
        this.filter = new BinnedFileFilter();
    }

    @Test
    public void testConstruction() {
        Assert.assertEquals((Object)"Binned_data_product", (Object)this.filter.getFormatName());
        String[] extensions = this.filter.getExtensions();
        Assert.assertEquals((long)1L, (long)extensions.length);
        Assert.assertEquals((Object)endsWith, (Object)extensions[0]);
        Assert.assertEquals((Object)"SeaDAS-Level-3-alike NetCDF files containing binned Level-3 data (*.nc)", (Object)this.filter.getDescription());
    }

    @Test
    public void testAccept() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        Assert.assertTrue((boolean)tempDir.isDirectory());
        Assert.assertTrue((boolean)this.filter.accept(tempDir));
        Assert.assertTrue((boolean)this.filter.accept(new File("ESACCI-OC-L3S-OC_PRODUCTS-MERGED-1M_MONTHLY_4km_PML_TEST_COMPOSITE_200306.nc")));
        Assert.assertFalse((boolean)this.filter.accept(new File("ESACCI-OC-L3S-OC_PRODUCTS-MERGED-1M_MONTHLY_4km_PML_TEST_COMPOSITE_200306")));
        Assert.assertFalse((boolean)this.filter.accept(new File("MER_FR__1PNUPA20070708_164713_000000982059_00384_27993_4986.N1")));
        Assert.assertFalse((boolean)this.filter.accept(new File("MER_FR__1PNUPA20070708_164713_000000982059_00384_27993_4986.nc")));
    }

    @Test
    public void testIsBinnedName_OC_CCI() {
        String startsWith_oc_cci = "ESACCI-OC-";
        String mustContain_oc_cci = "L3";
        String any = "__any_text__";
        Assert.assertEquals((Object)false, (Object)BinnedFileFilter.isBinnedName((String)"DoNotStartExpected__any_text__L3__any_text__.nc"));
        Assert.assertEquals((Object)false, (Object)BinnedFileFilter.isBinnedName((String)"ESACCI-OC-__any_text__doNotContainExpected__any_text__.nc"));
        Assert.assertEquals((Object)false, (Object)BinnedFileFilter.isBinnedName((String)"ESACCI-OC-__any_text__L3__any_text__endsNotWithExpected"));
        Assert.assertEquals((Object)true, (Object)BinnedFileFilter.isBinnedName((String)"ESACCI-OC-__any_text__L3__any_text__.nc"));
    }

    @Test
    public void testIsBinnedName_BEAM_Binning() {
        String mustContain_bins = "-bins";
        Assert.assertEquals((Object)false, (Object)BinnedFileFilter.isBinnedName((String)"StartsWithAnythingdoNotContain_binscontinuesWithAnything.nc"));
        Assert.assertEquals((Object)true, (Object)BinnedFileFilter.isBinnedName((String)"StartsWithAnything-binscontinuesWithAnything.nc"));
    }
}

