/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.binning.operator.metadata.MetadataAggregator;
import org.esa.snap.binning.operator.metadata.ProductNameMetaAggregator;
import org.esa.snap.binning.operator.metadata.TestHelper;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProductNameMetaAggregatorTest {
    private ProductNameMetaAggregator aggregator;

    @Before
    public void setUp() {
        this.aggregator = new ProductNameMetaAggregator();
    }

    @Test
    public void testInterfaceImplemented() {
        Assert.assertTrue((boolean)(this.aggregator instanceof MetadataAggregator));
    }

    @Test
    public void testAggregateNoProducts() {
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)0L, (long)metadataElement.getNumElements());
    }

    @Test
    public void testAggregateOneInput_withoutGraph() {
        Product product = TestHelper.createProduct(1);
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertInputElementAt(0, metadataElement);
    }

    @Test
    public void testAggregateThreeInputs_withoutGraph() {
        Product product = TestHelper.createProduct(1);
        this.aggregator.aggregateMetadata(product);
        product = TestHelper.createProduct(2);
        this.aggregator.aggregateMetadata(product);
        product = TestHelper.createProduct(3);
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)3L, (long)metadataElement.getNumElements());
        TestHelper.assertInputElementAt(0, metadataElement);
        TestHelper.assertInputElementAt(1, metadataElement);
        TestHelper.assertInputElementAt(2, metadataElement);
    }

    @Test
    public void testAggregateOneInput_withGraph() {
        Product product = TestHelper.createProductWithProcessingGraph(1, "inputProduct");
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertInputElementAt(0, "inputProduct", metadataElement);
    }

    @Test
    public void testAggregateOneInput_withGraph_withoutValidProductName() {
        Product product = TestHelper.createProductWithProcessingGraph(1, "inputProduct");
        MetadataElement node_0 = product.getMetadataRoot().getElement("Processing_Graph").getElement("node.0");
        MetadataElement sourcesElement = node_0.getElement("sources");
        MetadataAttribute sourceProductAttribute = sourcesElement.getAttribute("sourceProduct");
        sourcesElement.removeAttribute(sourceProductAttribute);
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertInputElementAt(0, "product_1", metadataElement);
    }
}

