/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.binning.operator.metadata.FirstHistoryMetaAggregator;
import org.esa.snap.binning.operator.metadata.MetadataAggregator;
import org.esa.snap.binning.operator.metadata.TestHelper;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FirstHistoryMetaAggregatorTest {
    private FirstHistoryMetaAggregator aggregator;

    @Before
    public void setUp() {
        this.aggregator = new FirstHistoryMetaAggregator();
    }

    @Test
    public void testInterfaceImplemented() {
        Assert.assertTrue((boolean)(this.aggregator instanceof MetadataAggregator));
    }

    @Test
    public void testAggregateNoProducts() {
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)0L, (long)metadataElement.getNumElements());
    }

    @Test
    public void testAggregateOneProductWithoutProcessingInfo() {
        Product product = TestHelper.createProduct(1);
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertInputElementAt(0, metadataElement);
    }

    @Test
    public void testAggregateOneProductWithProcessingInfo() {
        Product product = TestHelper.createProductWithProcessingGraph(1, "a-test_1", "a_test_2");
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertProductElementWithGraphAt(0, "a-test_1", metadataElement);
    }

    @Test
    public void testAggregateThreeProductWithProcessingInfo() {
        Product product = TestHelper.createProductWithProcessingGraph(1, "first input");
        this.aggregator.aggregateMetadata(product);
        product = TestHelper.createProductWithProcessingGraph(2, "second input");
        this.aggregator.aggregateMetadata(product);
        product = TestHelper.createProductWithProcessingGraph(3, "third input");
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)3L, (long)metadataElement.getNumElements());
        TestHelper.assertProductElementWithGraphAt(0, "first input", metadataElement);
        TestHelper.assertProductElementWithoutGraphtAt(1, "second input", metadataElement);
        TestHelper.assertProductElementWithoutGraphtAt(2, "third input", metadataElement);
    }
}

