/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.binning.operator.metadata.AllHistoriesMetaAggregator;
import org.esa.snap.binning.operator.metadata.MetadataAggregator;
import org.esa.snap.binning.operator.metadata.TestHelper;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AllHistoriesMetaAggregatorTest {
    private AllHistoriesMetaAggregator aggregator;

    @Before
    public void setUp() {
        this.aggregator = new AllHistoriesMetaAggregator();
    }

    @Test
    public void testInterfaceImplemented() {
        Assert.assertTrue((boolean)(this.aggregator instanceof MetadataAggregator));
    }

    @Test
    public void testAggregateNoProducts() {
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)0L, (long)metadataElement.getNumElements());
    }

    @Test
    public void testAggregateOneProductWithoutProcessingInfo() {
        Product product = TestHelper.createProduct(1);
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertInputElementAt(0, metadataElement);
    }

    @Test
    public void testAggregateOneProductWithProcessingInfo() {
        Product product = TestHelper.createProductWithProcessingGraph(1, "schnickschnack");
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)1L, (long)metadataElement.getNumElements());
        TestHelper.assertProductElementWithGraphAt(0, "schnickschnack", metadataElement);
    }

    @Test
    public void testAggregateThreeProductMixed() {
        Product product = TestHelper.createProductWithProcessingGraph(1, "one");
        this.aggregator.aggregateMetadata(product);
        product = TestHelper.createProduct(2);
        this.aggregator.aggregateMetadata(product);
        product = TestHelper.createProductWithProcessingGraph(3, "three");
        this.aggregator.aggregateMetadata(product);
        MetadataElement metadataElement = this.aggregator.getMetadata();
        TestHelper.assertCorrectNameAndNoAttributes(metadataElement);
        Assert.assertEquals((long)3L, (long)metadataElement.getNumElements());
        TestHelper.assertProductElementWithGraphAt(0, "one", metadataElement);
        TestHelper.assertProductElementWithoutGraphtAt(1, "product_2", metadataElement);
        TestHelper.assertProductElementWithGraphAt(2, "three", metadataElement);
    }
}

