/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import org.esa.snap.binning.operator.VariableConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariableConfigTest {
    private VariableConfig config;

    @Before
    public void setUp() {
        this.config = new VariableConfig();
    }

    @Test
    public void testParameterConstruction() {
        String name = "name";
        String expression = "expression";
        VariableConfig config = new VariableConfig("name", "expression");
        Assert.assertEquals((Object)"name", (Object)config.getName());
        Assert.assertEquals((Object)"expression", (Object)config.getExpr());
    }

    @Test
    public void testSetGetName() {
        String name = "a_name";
        this.config.setName("a_name");
        Assert.assertEquals((Object)"a_name", (Object)this.config.getName());
    }

    @Test
    public void testSetGetExpr() {
        String expression = "an _expr";
        this.config.setExpr("an _expr");
        Assert.assertEquals((Object)"an _expr", (Object)this.config.getExpr());
    }

    @Test
    public void testEquals_identity() {
        Assert.assertTrue((boolean)this.config.equals((Object)this.config));
    }

    @Test
    public void testEquals_wrongClass() {
        Assert.assertFalse((boolean)this.config.equals((Object)new Double(4.0)));
    }

    @Test
    public void testEquals_nullInput() {
        Assert.assertFalse((boolean)this.config.equals(null));
    }

    @Test
    public void testEquals_differentName() {
        String expression = "a>b";
        this.config.setName("Claire");
        this.config.setExpr("a>b");
        VariableConfig other = new VariableConfig();
        other.setName("Paul");
        other.setExpr("a>b");
        Assert.assertFalse((boolean)this.config.equals((Object)other));
    }

    @Test
    public void testEquals_differentExpression() {
        String name = "Claire";
        this.config.setName("Claire");
        this.config.setExpr("a>b");
        VariableConfig other = new VariableConfig();
        other.setName("Claire");
        other.setExpr("a=b+c");
        Assert.assertFalse((boolean)this.config.equals((Object)other));
    }

    @Test
    public void testEquals_equal() {
        String name = "Claire";
        String expression = "a>b";
        this.config.setName("Claire");
        this.config.setExpr("a>b");
        VariableConfig other = new VariableConfig();
        other.setName("Claire");
        other.setExpr("a>b");
        Assert.assertTrue((boolean)this.config.equals((Object)other));
    }

    @Test
    public void testHashCode() {
        this.config.setExpr("huhu");
        this.config.setName("Anna");
        Assert.assertEquals((long)66628634L, (long)this.config.hashCode());
    }
}

