/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.SpatialBinConsumer;
import org.esa.snap.binning.SpatialBinner;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.TemporalBinSource;
import org.esa.snap.binning.TemporalBinner;
import org.esa.snap.binning.operator.BinningConfig;
import org.esa.snap.binning.operator.Formatter;
import org.esa.snap.binning.operator.FormatterConfig;
import org.esa.snap.binning.operator.SpatialProductBinner;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.StopWatch;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.Ignore;

@Ignore
public class TestBinner {
    public static void main(String[] args) throws Exception {
        String sourceDirFile = args[0];
        String regionWktFile = args[1];
        String binnerConfigFile = args[2];
        String[] outputterConfigFiles = new String[args.length - 3];
        System.arraycopy(args, 3, outputterConfigFiles, 0, outputterConfigFiles.length);
        File[] sourceFiles = new File(sourceDirFile).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".N1");
            }
        });
        String regionWkt = FileUtils.readText((File)new File(regionWktFile));
        BinningConfig binningConfig = BinningConfig.fromXml((String)FileUtils.readText((File)new File(binnerConfigFile)));
        Debug.setEnabled((boolean)true);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        BinningContext binningContext = binningConfig.createBinningContext(null, null, null);
        SortedMap<Long, List<SpatialBin>> spatialBinMap = TestBinner.doSpatialBinning(binningContext, sourceFiles);
        List<TemporalBin> temporalBins = TestBinner.doTemporalBinning(binningContext, spatialBinMap);
        for (String outputterConfigFile : outputterConfigFiles) {
            FormatterConfig formatterConfig = FormatterConfig.fromXml((String)FileUtils.readText((File)new File(outputterConfigFile)));
            TestBinner.doOutputting(regionWkt, formatterConfig, binningContext, temporalBins);
        }
        stopWatch.stopAndTrace(String.format("Total time for binning %d product(s)", sourceFiles.length));
    }

    private static SortedMap<Long, List<SpatialBin>> doSpatialBinning(BinningContext binningContext, File[] sourceFiles) throws IOException {
        SpatialBinStore spatialBinStore = new SpatialBinStore();
        SpatialBinner spatialBinner = new SpatialBinner(binningContext, (SpatialBinConsumer)spatialBinStore);
        for (File sourceFile : sourceFiles) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            System.out.println("reading " + sourceFile);
            Product product = ProductIO.readProduct((File)sourceFile);
            System.out.println("processing " + sourceFile);
            long numObs = SpatialProductBinner.processProduct((Product)product, (SpatialBinner)spatialBinner, new HashMap(), (ProgressMonitor)ProgressMonitor.NULL);
            System.out.println("done, " + numObs + " observations processed");
            stopWatch.stopAndTrace("Spatial binning of product took");
        }
        return spatialBinStore.getSpatialBinMap();
    }

    private static List<TemporalBin> doTemporalBinning(BinningContext binningContext, SortedMap<Long, List<SpatialBin>> spatialBinMap) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        TemporalBinner temporalBinner = new TemporalBinner(binningContext);
        ArrayList<TemporalBin> temporalBins = new ArrayList<TemporalBin>();
        for (Map.Entry<Long, List<SpatialBin>> entry : spatialBinMap.entrySet()) {
            TemporalBin temporalBin = temporalBinner.processSpatialBins(entry.getKey().longValue(), (Iterable)entry.getValue());
            temporalBins.add(temporalBin);
        }
        stopWatch.stopAndTrace("Temporal binning took");
        return temporalBins;
    }

    private static void doOutputting(String regionWKT, FormatterConfig formatterConfig, BinningContext binningContext, List<TemporalBin> temporalBins) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PlanetaryGrid planetaryGrid = binningContext.getPlanetaryGrid();
        String[] resultFeatureNames = binningContext.getBinManager().getResultFeatureNames();
        Formatter.format((PlanetaryGrid)planetaryGrid, (TemporalBinSource)new MyTemporalBinSource(temporalBins), (String[])resultFeatureNames, (FormatterConfig)formatterConfig, (Geometry)new WKTReader().read(regionWKT), (ProductData.UTC)new ProductData.UTC(), (ProductData.UTC)new ProductData.UTC(), (MetadataElement[])new MetadataElement[]{new MetadataElement("TODO_add_metadata_here")});
        stopWatch.stopAndTrace("Writing output took");
    }

    private static class MyTemporalBinSource
    implements TemporalBinSource {
        private final List<TemporalBin> temporalBins;

        public MyTemporalBinSource(List<TemporalBin> temporalBins) {
            this.temporalBins = temporalBins;
        }

        public int open() throws IOException {
            return 1;
        }

        public Iterator<? extends TemporalBin> getPart(int index) throws IOException {
            return this.temporalBins.iterator();
        }

        public void partProcessed(int index, Iterator<? extends TemporalBin> part) throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private static class SpatialBinStore
    implements SpatialBinConsumer {
        private final SortedMap<Long, List<SpatialBin>> spatialBinMap = new TreeMap<Long, List<SpatialBin>>();

        private SpatialBinStore() {
        }

        public SortedMap<Long, List<SpatialBin>> getSpatialBinMap() {
            return this.spatialBinMap;
        }

        public void consumeSpatialBins(BinningContext binningContext, List<SpatialBin> spatialBins) {
            for (SpatialBin spatialBin : spatialBins) {
                ArrayList<SpatialBin> spatialBinList = (ArrayList<SpatialBin>)this.spatialBinMap.get(spatialBin.getIndex());
                if (spatialBinList == null) {
                    spatialBinList = new ArrayList<SpatialBin>();
                    this.spatialBinMap.put(spatialBin.getIndex(), spatialBinList);
                }
                spatialBinList.add(spatialBin);
            }
        }
    }
}

