/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.binning.operator.SpatialDataDaySourceProductFilter;
import org.esa.snap.binning.operator.TestUtils;
import org.esa.snap.core.datamodel.Product;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SpatialDataDaySourceProductFilterTest {
    private BinningProductFilter parent;
    private DataPeriod dataPeriod;
    private SpatialDataDaySourceProductFilter filter;

    @Before
    public void setUp() throws Exception {
        this.parent = (BinningProductFilter)Mockito.mock(BinningProductFilter.class);
        Mockito.when((Object)this.parent.accept((Product)Matchers.any(Product.class))).thenReturn((Object)true);
        this.dataPeriod = TestUtils.createSpatialDataPeriod();
        this.filter = new SpatialDataDaySourceProductFilter(this.parent, this.dataPeriod);
    }

    @Test
    public void testAccept() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept(this.createProduct(DataPeriod.Membership.PREVIOUS_PERIODS, DataPeriod.Membership.PREVIOUS_PERIODS)));
        Assert.assertTrue((boolean)this.filter.accept(this.createProduct(DataPeriod.Membership.PREVIOUS_PERIODS, DataPeriod.Membership.CURRENT_PERIOD)));
        Assert.assertTrue((boolean)this.filter.accept(this.createProduct(DataPeriod.Membership.PREVIOUS_PERIODS, DataPeriod.Membership.SUBSEQUENT_PERIODS)));
        Assert.assertTrue((boolean)this.filter.accept(this.createProduct(DataPeriod.Membership.CURRENT_PERIOD, DataPeriod.Membership.CURRENT_PERIOD)));
        Assert.assertTrue((boolean)this.filter.accept(this.createProduct(DataPeriod.Membership.CURRENT_PERIOD, DataPeriod.Membership.SUBSEQUENT_PERIODS)));
        Assert.assertFalse((boolean)this.filter.accept(this.createProduct(DataPeriod.Membership.SUBSEQUENT_PERIODS, DataPeriod.Membership.SUBSEQUENT_PERIODS)));
    }

    @Test
    public void testRejectProduct_IfParentFilterDoNotAcceptTheProduct() {
        Mockito.when((Object)this.parent.accept((Product)Matchers.any(Product.class))).thenReturn((Object)false);
        Mockito.when((Object)this.parent.getReason()).thenReturn((Object)"parent reason");
        Assert.assertThat((Object)this.filter.accept((Product)Mockito.mock(Product.class)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.filter.getReason(), (Matcher)CoreMatchers.is((Object)"parent reason"));
    }

    private Product createProduct(DataPeriod.Membership firstPeriod, DataPeriod.Membership lastPeriod) {
        return TestUtils.createProduct(this.dataPeriod, firstPeriod, lastPeriod);
    }
}

