/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.operator.SeaDASLevel3BinWriter;
import org.esa.snap.binning.support.BinningContextImpl;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.binning.support.VariableContextImpl;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import org.geotools.geometry.jts.JTS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class SeaDASLevel3BinWriterTest {
    private int numRows;
    private BinWriter binWriter;
    private File tempFile;

    @Before
    public void setUp() throws Exception {
        this.numRows = 216;
        this.tempFile = File.createTempFile("SeaDASLevel3BinWriterTest-temp", ".nc");
        this.binWriter = this.createBinWriter(this.tempFile, this.numRows);
    }

    @After
    public void tearDown() throws Exception {
        File binTempFile;
        if (this.tempFile != null && !this.tempFile.delete()) {
            this.tempFile.deleteOnExit();
        }
        if (this.binWriter != null && !(binTempFile = new File(this.binWriter.getTargetFilePath())).delete()) {
            binTempFile.deleteOnExit();
        }
    }

    @Test
    public void testWriting() throws Exception {
        HashMap<String, String> metadataProperties = this.createMetadataProperties();
        ArrayList<TemporalBin> temporalBins = this.createTemporalBins();
        this.binWriter.write(metadataProperties, temporalBins);
        NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)this.binWriter.getTargetFilePath());
        Assert.assertNotNull((Object)netcdfFile.findGlobalAttribute("title"));
        Assert.assertNotNull((Object)netcdfFile.findGlobalAttribute("super_sampling"));
        Assert.assertEquals((Object)(this.numRows * 2), (Object)netcdfFile.findGlobalAttribute("SEAGrid_bins").getNumericValue());
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findDimension("bin_index").getLength());
        Assert.assertEquals((long)temporalBins.size(), (long)netcdfFile.findDimension("bin_list").getLength());
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_row_num").getDimension(0).getLength());
        Array bi_row_num = netcdfFile.findVariable("bi_row_num").read();
        Assert.assertEquals((long)0L, (long)bi_row_num.getInt(0));
        Assert.assertEquals((long)200L, (long)bi_row_num.getInt(200));
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_vsize").getDimension(0).getLength());
        Array bi_vsize = netcdfFile.findVariable("bi_vsize").read();
        Assert.assertEquals((double)(180.0 / (double)this.numRows), (double)bi_vsize.getDouble(this.numRows / 2), (double)1.0E-6);
        Assert.assertEquals((double)(180.0 / (double)this.numRows), (double)bi_vsize.getDouble(0), (double)1.0E-6);
        Assert.assertEquals((double)(180.0 / (double)this.numRows), (double)bi_vsize.getDouble(215), (double)1.0E-6);
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_hsize").getDimension(0).getLength());
        Array bi_hsize = netcdfFile.findVariable("bi_hsize").read();
        Assert.assertEquals((double)(360.0 / ((double)this.numRows * 2.0)), (double)bi_hsize.getDouble(this.numRows / 2), (double)1.0E-6);
        Assert.assertEquals((double)120.0, (double)bi_hsize.getDouble(215), (double)1.0E-6);
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_start_num").getDimension(0).getLength());
        Array bi_start_num = netcdfFile.findVariable("bi_start_num").read();
        Assert.assertEquals((long)1L, (long)bi_start_num.getInt(215));
        Assert.assertEquals((long)4L, (long)bi_start_num.getInt(214));
        Assert.assertEquals((long)12315L, (long)bi_start_num.getInt(150));
        Assert.assertEquals((long)59406L, (long)bi_start_num.getInt(0));
        Assert.assertNotNull((Object)netcdfFile.findVariable("bi_begin_offset"));
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_begin_offset").getDimension(0).getLength());
        Array bi_begin_offset = netcdfFile.findVariable("bi_begin_offset").read();
        Assert.assertEquals((long)0L, (long)bi_begin_offset.getInt(150));
        Assert.assertEquals((long)-1L, (long)bi_begin_offset.getInt(214));
        Assert.assertEquals((long)-1L, (long)bi_begin_offset.getInt(0));
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_begin").getDimension(0).getLength());
        Array bi_begin = netcdfFile.findVariable("bi_begin").read();
        Assert.assertEquals((long)0L, (long)bi_begin.getInt(10));
        Assert.assertEquals((long)46774L, (long)bi_begin.getInt(150));
        Assert.assertEquals((long)0L, (long)bi_begin.getInt(215));
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_extent").getDimension(0).getLength());
        Array bi_extent = netcdfFile.findVariable("bi_extent").read();
        Assert.assertEquals((long)0L, (long)bi_extent.getInt(10));
        Assert.assertEquals((long)2L, (long)bi_extent.getInt(150));
        Assert.assertEquals((long)0L, (long)bi_extent.getInt(215));
        Assert.assertEquals((long)this.numRows, (long)netcdfFile.findVariable("bi_max").getDimension(0).getLength());
        Array bi_max = netcdfFile.findVariable("bi_max").read();
        Assert.assertEquals((long)3L, (long)bi_max.getInt(0));
        Assert.assertEquals((long)(this.numRows * 2), (long)bi_max.getInt(this.numRows / 2));
        Assert.assertEquals((long)3L, (long)bi_max.getInt(215));
        Assert.assertEquals((long)temporalBins.size(), (long)netcdfFile.findVariable("bl_bin_num").getDimension(0).getLength());
        Array bl_bin_num = netcdfFile.findVariable("bl_bin_num").read();
        Assert.assertEquals((long)46774L, (long)bl_bin_num.getInt(0));
        Assert.assertEquals((long)46775L, (long)bl_bin_num.getInt(1));
        Assert.assertEquals((long)temporalBins.size(), (long)netcdfFile.findVariable("bl_nobs").getDimension(0).getLength());
        Array bl_nobs = netcdfFile.findVariable("bl_nobs").read();
        Assert.assertEquals((long)1L, (long)bl_nobs.getInt(0));
        Assert.assertEquals((long)2L, (long)bl_nobs.getInt(1));
        Assert.assertEquals((long)temporalBins.size(), (long)netcdfFile.findVariable("bl_nscenes").getDimension(0).getLength());
        Array bl_nscenes = netcdfFile.findVariable("bl_nscenes").read();
        Assert.assertEquals((long)1L, (long)bl_nscenes.getInt(0));
        Assert.assertEquals((long)2L, (long)bl_nscenes.getInt(1));
        Assert.assertEquals((long)temporalBins.size(), (long)netcdfFile.findVariable("bl_test_min").getDimension(0).getLength());
        Array bl_test_min = netcdfFile.findVariable("bl_test_min").read();
        Assert.assertEquals((double)0.004f, (double)bl_test_min.getFloat(0), (double)1.0E-6);
        Assert.assertEquals((double)0.398f, (double)bl_test_min.getFloat(1), (double)1.0E-6);
        Assert.assertEquals((long)temporalBins.size(), (long)netcdfFile.findVariable("bl_test_max").getDimension(0).getLength());
        Array bl_test_max = netcdfFile.findVariable("bl_test_max").read();
        Assert.assertEquals((double)0.14f, (double)bl_test_max.getFloat(0), (double)1.0E-6);
        Assert.assertEquals((double)0.89f, (double)bl_test_max.getFloat(1), (double)1.0E-6);
    }

    @Test
    public void testWriting_startAndStopTimeMetadata() throws Exception {
        HashMap<String, String> metadataProperties = this.createMetadataProperties();
        ArrayList<TemporalBin> temporalBins = this.createTemporalBins();
        Date startTime = new Date(500000000000L);
        Date stopTime = new Date(510000000000L);
        BinWriter binWriterWithUtc = this.createBinWriter(this.tempFile, this.numRows, ProductData.UTC.create((Date)startTime, (long)0L), ProductData.UTC.create((Date)stopTime, (long)0L));
        binWriterWithUtc.write(metadataProperties, temporalBins);
        NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)binWriterWithUtc.getTargetFilePath());
        Attribute startTimeAttribute = netcdfFile.findGlobalAttribute("start_time");
        Assert.assertNotNull((Object)startTimeAttribute);
        Assert.assertEquals((Object)"1985-11-05T00:53:20.000", (Object)startTimeAttribute.getStringValue());
        Attribute stopTimeAttribute = netcdfFile.findGlobalAttribute("stop_time");
        Assert.assertNotNull((Object)stopTimeAttribute);
        Assert.assertEquals((Object)"1986-02-28T18:40:00.000", (Object)stopTimeAttribute.getStringValue());
        Attribute startCoverageAttribute = netcdfFile.findGlobalAttribute("time_coverage_start");
        Assert.assertNotNull((Object)startCoverageAttribute);
        Assert.assertEquals((Object)"1985-11-05T00:53:20.000", (Object)startCoverageAttribute.getStringValue());
        Attribute endCoverageAttribute = netcdfFile.findGlobalAttribute("time_coverage_end");
        Assert.assertNotNull((Object)endCoverageAttribute);
        Assert.assertEquals((Object)"1986-02-28T18:40:00.000", (Object)endCoverageAttribute.getStringValue());
    }

    @Test
    public void testToDateString() {
        Date dateTime = new Date(520000000000L);
        ProductData.UTC utc = ProductData.UTC.create((Date)dateTime, (long)0L);
        String utcString = SeaDASLevel3BinWriter.toDateString((ProductData.UTC)utc);
        Assert.assertEquals((Object)"1986-06-24T12:26:40.000", (Object)utcString);
    }

    @Test
    public void testToDateString_nullInput() {
        String utcString = SeaDASLevel3BinWriter.toDateString(null);
        Assert.assertEquals((Object)"", (Object)utcString);
    }

    private ArrayList<TemporalBin> createTemporalBins() {
        ArrayList<TemporalBin> temporalBins = new ArrayList<TemporalBin>();
        temporalBins.add(new TemporalBin(12345L, 2));
        temporalBins.add(new TemporalBin(12346L, 2));
        float[][] data = new float[][]{{0.004f, 0.14f}, {0.398f, 0.89f}};
        for (int i = 0; i < temporalBins.size(); ++i) {
            TemporalBin temporalBin = temporalBins.get(i);
            temporalBin.getFeatureValues()[0] = data[i][0];
            temporalBin.getFeatureValues()[1] = data[i][1];
            temporalBin.setNumObs(i + 1);
            temporalBin.setNumPasses(i + 1);
        }
        return temporalBins;
    }

    private HashMap<String, String> createMetadataProperties() {
        HashMap<String, String> metadataProperties = new HashMap<String, String>();
        metadataProperties.put("test", "Spongebob");
        return metadataProperties;
    }

    private BinWriter createBinWriter(File tempFile, int numRows) {
        ProductData.UTC startTime = null;
        ProductData.UTC stopTime = null;
        return this.createBinWriter(tempFile, numRows, startTime, stopTime);
    }

    private BinWriter createBinWriter(File tempFile, int numRows, ProductData.UTC startTime, ProductData.UTC stopTime) {
        SEAGrid seaGrid = new SEAGrid(numRows);
        VariableContextImpl variableContext = new VariableContextImpl();
        variableContext.defineVariable("test", "blah");
        BinManager binManager = new BinManager((VariableContext)variableContext, new Aggregator[]{new AggregatorMinMax((VariableContext)variableContext, "test", "test")});
        BinningContextImpl binningContext = new BinningContextImpl((PlanetaryGrid)seaGrid, binManager, CompositingType.BINNING, 1, null, null);
        Geometry region = JTS.shapeToGeometry((Shape)new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0), (GeometryFactory)new GeometryFactory());
        SeaDASLevel3BinWriter binWriter = new SeaDASLevel3BinWriter(region, startTime, stopTime);
        binWriter.setBinningContext((BinningContext)binningContext);
        binWriter.setTargetFileTemplatePath(tempFile.getAbsolutePath());
        binWriter.setLogger(Logger.getLogger("SeaDASLevel3BinWriterTest"));
        return binWriter;
    }
}

