/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.binding.ConversionException;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.ProductCustomizer;
import org.esa.snap.binning.Reprojector;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.operator.ProductTemporalBinRenderer;
import org.esa.snap.binning.support.BinningContextImpl;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.junit.Assert;
import org.junit.Test;

public class ProductTemporalBinRendererTest {
    @Test
    public void testRenderBin() throws Exception {
        File tempFile = File.createTempFile("BEAM", ".nc");
        tempFile.deleteOnExit();
        BinningContextImpl binningContext = new BinningContextImpl((PlanetaryGrid)new SEAGrid(10), new BinManager(), CompositingType.BINNING, 1, null, null);
        ProductTemporalBinRenderer binRenderer = this.createBinRenderer(tempFile, binningContext, null);
        Rectangle region = binRenderer.getRasterRegion();
        Product product = this.renderBins(tempFile, binRenderer, region);
        Band numObs = product.getBand("num_obs");
        numObs.loadRasterData();
        int[] actualObsLine = new int[region.width];
        int[] expectedObsLine = new int[region.width];
        for (int y = 0; y < region.height; ++y) {
            numObs.readPixels(0, y, region.width, 1, actualObsLine);
            Arrays.fill(expectedObsLine, y);
            if (y == 3) {
                expectedObsLine[0] = -1;
            }
            Assert.assertArrayEquals((int[])expectedObsLine, (int[])actualObsLine);
        }
        Band numPasses = product.getBand("num_passes");
        numPasses.loadRasterData();
        int[] actualPassesLine = new int[region.width];
        int[] expectedPassesLine = new int[region.width];
        for (int y = 0; y < region.height; ++y) {
            numPasses.readPixels(0, y, region.width, 1, actualPassesLine);
            Arrays.fill(expectedPassesLine, y + 1);
            if (y == 3) {
                expectedPassesLine[0] = -1;
            }
            Assert.assertArrayEquals((String)("row=" + y), (int[])expectedPassesLine, (int[])actualPassesLine);
        }
    }

    @Test
    public void testRenderBinWithCustomizer() throws Exception {
        File tempFile = File.createTempFile("BEAM", ".nc");
        tempFile.deleteOnExit();
        BinningContextImpl binningContext = new BinningContextImpl((PlanetaryGrid)new SEAGrid(10), new BinManager(), CompositingType.BINNING, 1, null, null);
        ProductTemporalBinRenderer binRenderer = this.createBinRenderer(tempFile, binningContext, new MyProductCustomizer());
        Rectangle region = binRenderer.getRasterRegion();
        Product product = this.renderBins(tempFile, binRenderer, region);
        Band numObs = product.getBand("num_obs");
        numObs.loadRasterData();
        int[] actualObsLine = new int[region.width];
        int[] expectedObsLine = new int[region.width];
        for (int y = 0; y < region.height; ++y) {
            numObs.readPixels(0, y, region.width, 1, actualObsLine);
            Arrays.fill(expectedObsLine, y);
            if (y == 3) {
                expectedObsLine[0] = -1;
            }
            Assert.assertArrayEquals((int[])expectedObsLine, (int[])actualObsLine);
        }
        Band numPasses = product.getBand("num_passes");
        Assert.assertNull((Object)numPasses);
        Band const3 = product.getBand("const3");
        Assert.assertNotNull((Object)const3);
        const3.loadRasterData();
        int[] actualConst3Line = new int[region.width];
        int[] expectedConst3Line = new int[region.width];
        Arrays.fill(expectedConst3Line, 3);
        for (int y = 0; y < region.height; ++y) {
            const3.readPixels(0, y, region.width, 1, actualConst3Line);
            Assert.assertArrayEquals((int[])expectedConst3Line, (int[])actualConst3Line);
        }
    }

    private Product renderBins(File tempFile, ProductTemporalBinRenderer binRenderer, Rectangle region) throws IOException {
        binRenderer.begin();
        TemporalBin temporalBin = new TemporalBin(0L, 11);
        for (int y = 0; y < region.height; ++y) {
            temporalBin.setNumObs(y);
            temporalBin.setNumPasses(y + 1);
            for (int x = 0; x < region.width; ++x) {
                if (x == 0 && y == 3) {
                    binRenderer.renderMissingBin(x, y);
                    continue;
                }
                binRenderer.renderBin(x, y, temporalBin, null);
            }
        }
        binRenderer.end();
        return ProductIO.readProduct((File)tempFile);
    }

    private ProductTemporalBinRenderer createBinRenderer(File tempFile, BinningContextImpl binningContext, ProductCustomizer productCustomizer) throws IOException, ConversionException, ParseException {
        String worldWKT = "POLYGON ((-180 -90, -180 90, 180 90, 180 -90, -180 -90))";
        Rectangle region = Reprojector.computeRasterSubRegion((PlanetaryGrid)binningContext.getPlanetaryGrid(), (Geometry)new JtsGeometryConverter().parse(worldWKT));
        ProductData.UTC startTime = ProductData.UTC.parse((String)"12-May-2006 11:50:10");
        ProductData.UTC endTime = ProductData.UTC.parse((String)"12-May-2006 11:55:15");
        String[] resultFeatureNames = binningContext.getBinManager().getResultFeatureNames();
        return new ProductTemporalBinRenderer(resultFeatureNames, tempFile, "NetCDF-BEAM", region, 1.0, startTime, endTime, productCustomizer, new MetadataElement[0]);
    }

    private class MyProductCustomizer
    extends ProductCustomizer {
        private MyProductCustomizer() {
        }

        public void customizeProduct(Product product) {
            product.removeBand(product.getBand("num_passes"));
            Band const3 = product.addBand("const3", 12);
            int width = product.getSceneRasterWidth();
            int height = product.getSceneRasterHeight();
            const3.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])new Integer[]{3}, null));
        }
    }
}

