/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MappedByteBufferTest {
    static final int MiB = 0x100000;
    static final int N = 25000;
    File file;

    @Before
    public void setUp() throws Exception {
        this.file = MappedByteBufferTest.genTestFile();
        this.file.deleteOnExit();
        MappedByteBufferTest.deleteFile("setUp", this.file);
    }

    @After
    public void tearDown() throws Exception {
        MappedByteBufferTest.deleteFile("tearDown", this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="fails on tearDown()")
    @Test
    public void testThatMemoryMappedFileIODoesNotConsumeHeapSpace() throws Exception {
        long mem4;
        long mem3;
        long mem2;
        long mem1;
        int fileSize = Integer.MAX_VALUE;
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        FileChannel fc = raf.getChannel();
        try {
            mem1 = MappedByteBufferTest.getFreeMiB();
            MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
            mem2 = MappedByteBufferTest.getFreeMiB();
            buffer.putDouble(1.2);
            buffer.putFloat(3.4f);
            buffer.putLong(0x7FFFFFF7, 123456789L);
        }
        finally {
            mem3 = MappedByteBufferTest.getFreeMiB();
            raf.close();
            mem4 = MappedByteBufferTest.getFreeMiB();
        }
        Assert.assertTrue((boolean)this.file.exists());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.file.length());
        System.out.println("free mem before opening: " + mem1 + " MiB");
        System.out.println("free mem after opening:  " + mem2 + " MiB");
        System.out.println("free mem before closing: " + mem3 + " MiB");
        System.out.println("free mem after closing:  " + mem4 + " MiB");
        Assert.assertEquals((long)mem2, (long)mem1);
        Assert.assertEquals((long)mem3, (long)mem1);
        Assert.assertEquals((long)mem4, (long)mem1);
        try (DataInputStream stream = new DataInputStream(new FileInputStream(this.file));){
            Assert.assertEquals((double)1.2, (double)stream.readDouble(), (double)1.0E-10);
            Assert.assertEquals((double)3.4, (double)stream.readFloat(), (double)1.0E-5f);
            stream.skip(2147483627L);
            Assert.assertEquals((long)123456789L, (long)stream.readLong());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="fails on tearDown()")
    @Test
    public void testThatFileMappingsCanGrow() throws Exception {
        int chunkSize = 0x6400000;
        RandomAccessFile raf1 = new RandomAccessFile(this.file, "rw");
        FileChannel gc1 = raf1.getChannel();
        try {
            MappedByteBuffer buffer1 = gc1.map(FileChannel.MapMode.READ_WRITE, 0L, 0x6400000L);
            buffer1.putDouble(0, 0.111);
            buffer1.putDouble(104857592, 1.222);
        }
        finally {
            raf1.close();
            Assert.assertEquals((long)0x6400000L, (long)this.file.length());
        }
        RandomAccessFile raf2 = new RandomAccessFile(this.file, "rw");
        FileChannel fc2 = raf2.getChannel();
        try {
            MappedByteBuffer buffer2 = fc2.map(FileChannel.MapMode.READ_WRITE, 0L, 0xC800000L);
            Assert.assertEquals((double)0.111, (double)buffer2.getDouble(0), (double)1.0E-10);
            Assert.assertEquals((double)1.222, (double)buffer2.getDouble(104857592), (double)1.0E-10);
            buffer2.putDouble(209715192, 2.333);
        }
        finally {
            raf2.close();
            Assert.assertEquals((long)0xC800000L, (long)this.file.length());
        }
        RandomAccessFile raf3 = new RandomAccessFile(this.file, "rw");
        FileChannel fc3 = raf3.getChannel();
        try {
            MappedByteBuffer buffer3 = fc3.map(FileChannel.MapMode.READ_WRITE, 0L, 314572800L);
            Assert.assertEquals((double)0.111, (double)buffer3.getDouble(0), (double)1.0E-10);
            Assert.assertEquals((double)1.222, (double)buffer3.getDouble(104857592), (double)1.0E-10);
            Assert.assertEquals((double)2.333, (double)buffer3.getDouble(209715192), (double)1.0E-10);
            buffer3.putDouble(314572792, 3.444);
        }
        finally {
            fc3.close();
            raf3.close();
            Assert.assertEquals((long)314572800L, (long)this.file.length());
        }
        RandomAccessFile raf4 = new RandomAccessFile(this.file, "rw");
        FileChannel fc4 = raf4.getChannel();
        try {
            MappedByteBuffer buffer4 = fc4.map(FileChannel.MapMode.READ_WRITE, 0L, 314572800L);
            Assert.assertEquals((double)0.111, (double)buffer4.getDouble(0), (double)1.0E-10);
            Assert.assertEquals((double)1.222, (double)buffer4.getDouble(104857592), (double)1.0E-10);
            Assert.assertEquals((double)2.333, (double)buffer4.getDouble(209715192), (double)1.0E-10);
            Assert.assertEquals((double)3.444, (double)buffer4.getDouble(314572792), (double)1.0E-10);
        }
        finally {
            raf4.close();
            Assert.assertEquals((long)314572800L, (long)this.file.length());
        }
    }

    @Test
    public void testStreamedFileIOPerformance() throws Exception {
        this.testFileIOPerformance(new StreamedFileIO());
    }

    @Ignore(value="fails on tearDown()")
    @Test
    public void testMemoryMappedFileIOPerformance() throws Exception {
        this.testFileIOPerformance(new MemoryMappedFileIO());
    }

    private void testFileIOPerformance(FileIO fileIO) throws IOException {
        System.out.println("Testing " + fileIO.getClass().getSimpleName() + " for " + 25000 + " samples");
        MyProducer producer = new MyProducer();
        MyConsumer consumer = new MyConsumer();
        long t1 = System.currentTimeMillis();
        fileIO.write(this.file, 25000, producer);
        long t2 = System.currentTimeMillis();
        fileIO.read(this.file, consumer);
        long t3 = System.currentTimeMillis();
        Assert.assertEquals((long)25000L, (long)producer.n);
        Assert.assertEquals((long)25000L, (long)consumer.n);
        System.out.println("buf write time: " + (t2 - t1) + " ms");
        System.out.println("buf read time:  " + (t3 - t2) + " ms");
        System.out.println("buf total time: " + (t3 - t1) + " ms");
        System.out.println("file size:      " + this.file.length() + " bytes");
    }

    private static long getFreeMiB() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public static File genTestFile() throws IOException {
        return File.createTempFile(MappedByteBufferTest.class.getSimpleName() + "-", ".dat");
    }

    public static void deleteFile(String msg, File file) throws InterruptedException {
        if (file.exists() && !file.delete()) {
            Assert.fail((String)("error: " + msg + ": failed to delete test file " + file));
        }
    }

    private static class MyConsumer
    implements Consumer {
        long n;

        private MyConsumer() {
        }

        @Override
        public void process(long key, float[] samples) {
            ++this.n;
        }
    }

    private static class MyProducer
    implements Producer {
        long n;

        private MyProducer() {
        }

        @Override
        public long createKey() {
            return this.n++;
        }

        @Override
        public float[] createSamples() {
            float[] samples = new float[(int)(Math.random() * 11.0)];
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = 0.1f * (float)i;
            }
            return samples;
        }
    }

    class StreamedFileIO
    implements FileIO {
        StreamedFileIO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(File file, int n, Producer producer) throws IOException {
            try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));){
                for (int i = 0; i < n; ++i) {
                    long key = producer.createKey();
                    float[] samples = producer.createSamples();
                    this.writeKey(stream, key);
                    this.writeSamples(stream, samples);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(File file, Consumer consumer) throws IOException {
            int n = 0;
            try (DataInputStream stream = new DataInputStream(new FileInputStream(file));){
                while (true) {
                    long key;
                    try {
                        key = this.readKey(stream);
                    }
                    catch (EOFException eof) {
                        break;
                    }
                    float[] samples = this.readSamples(stream);
                    consumer.process(key, samples);
                    ++n;
                }
            }
            return n;
        }

        private long readKey(DataInputStream is) throws IOException {
            return is.readLong();
        }

        private float[] readSamples(DataInputStream is) throws IOException {
            int n = is.readInt();
            float[] samples = new float[n];
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = is.readFloat();
            }
            return samples;
        }

        private void writeKey(DataOutputStream stream, long key) throws IOException {
            stream.writeLong(key);
        }

        private void writeSamples(DataOutputStream stream, float[] samples) throws IOException {
            stream.writeInt(samples.length);
            for (float sample : samples) {
                stream.writeFloat(sample);
            }
        }
    }

    class MemoryMappedFileIO
    implements FileIO {
        MemoryMappedFileIO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(File file, int n, Producer producer) throws IOException {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x6400000L);
            try {
                for (int i = 0; i < n; ++i) {
                    long key = producer.createKey();
                    float[] samples = producer.createSamples();
                    this.writeKey(buffer, key);
                    this.writeSamples(buffer, samples);
                }
            }
            finally {
                this.writeKey(buffer, -1L);
                raf.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(File file, Consumer consumer) throws IOException {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            long length = file.length();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, length);
            int n = 0;
            try {
                long key;
                while ((key = this.readKey(buffer)) != -1L) {
                    float[] samples = this.readSamples(buffer);
                    consumer.process(key, samples);
                    ++n;
                }
            }
            finally {
                raf.close();
            }
            return n;
        }

        private long readKey(ByteBuffer is) throws IOException {
            return is.getLong();
        }

        private float[] readSamples(ByteBuffer is) throws IOException {
            int n = is.getInt();
            float[] samples = new float[n];
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = is.getFloat();
            }
            return samples;
        }

        private void writeKey(ByteBuffer stream, long key) throws IOException {
            stream.putLong(key);
        }

        private void writeSamples(ByteBuffer stream, float[] samples) throws IOException {
            stream.putInt(samples.length);
            for (float sample : samples) {
                stream.putFloat(sample);
            }
        }
    }

    static interface Consumer {
        public void process(long var1, float[] var3);
    }

    static interface Producer {
        public long createKey();

        public float[] createSamples();
    }

    static interface FileIO {
        public void write(File var1, int var2, Producer var3) throws IOException;

        public int read(File var1, Consumer var2) throws IOException;
    }
}

