/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import org.esa.snap.binning.operator.GeoCodingProductFilter;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GeoCodingProductFilterTest {
    private GeoCoding geoCoding;
    private Product product;
    private GeoCodingProductFilter filter;

    @Before
    public void setUp() throws Exception {
        this.geoCoding = (GeoCoding)Mockito.mock(GeoCoding.class);
        this.product = (Product)Mockito.mock(Product.class);
        this.filter = new GeoCodingProductFilter();
    }

    @Test
    public void testAcceptProduct_WithProperGeoCoding() throws Exception {
        Mockito.when((Object)this.product.getSceneGeoCoding()).thenReturn((Object)this.geoCoding);
        Mockito.when((Object)this.geoCoding.canGetGeoPos()).thenReturn((Object)true);
        Assert.assertThat((Object)this.filter.accept(this.product), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.filter.getReason(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testRejectProduct_WhenGeoCodingCanNotGetGeoPos() throws Exception {
        Mockito.when((Object)this.product.getSceneGeoCoding()).thenReturn((Object)this.geoCoding);
        Mockito.when((Object)this.geoCoding.canGetGeoPos()).thenReturn((Object)false);
        Assert.assertThat((Object)this.filter.accept(this.product), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.filter.getReason(), (Matcher)CoreMatchers.is((Object)"Rejected because it does not contain a proper geo coding."));
    }

    @Test
    public void testRejectProduct_WhenProductContainsNoGeoCoding() throws Exception {
        Mockito.when((Object)this.product.getSceneGeoCoding()).thenReturn(null);
        Assert.assertThat((Object)this.filter.accept(this.product), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.filter.getReason(), (Matcher)CoreMatchers.is((Object)"Rejected because it does not contain a proper geo coding."));
    }
}

