/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.operator.GeneralSpatialBinCollector;
import org.esa.snap.binning.operator.SpatialBinCollection;
import org.esa.snap.binning.support.SEAGrid;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GeneralSpatialBinCollectorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumeSpatialBins() throws Exception {
        SEAGrid seaGrid = new SEAGrid(10);
        try (GeneralSpatialBinCollector store = new GeneralSpatialBinCollector(seaGrid.getNumBins());){
            BinningContext ctx = (BinningContext)Mockito.mock(BinningContext.class);
            Mockito.when((Object)ctx.getPlanetaryGrid()).thenReturn((Object)seaGrid);
            ArrayList<SpatialBin> spatialBins = new ArrayList<SpatialBin>();
            spatialBins.add(this.createSpatialBin(23L));
            store.consumeSpatialBins(ctx, spatialBins);
            store.consumingCompleted();
            SpatialBinCollection binMap = store.getSpatialBinCollection();
            Iterable actualBinLists = binMap.getBinCollection();
            List binList = (List)actualBinLists.iterator().next();
            Assert.assertEquals((long)23L, (long)((SpatialBin)binList.get(0)).getIndex());
        }
    }

    private SpatialBin createSpatialBin(long binIndex) {
        return new SpatialBin(binIndex, 2);
    }
}

