/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.binding.BindingException;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.aggregators.AggregatorOnMaxSet;
import org.esa.snap.binning.operator.BinningConfig;
import org.esa.snap.binning.operator.BinningConfigTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinningConfigWithProcessorTest {
    private BinningConfig config;

    @Before
    public void initBinningConfig() throws Exception {
        this.config = BinningConfigTest.loadConfig("BinningConfigWithProcessorTest.xml");
    }

    @Test
    public void testResultingBinManager() {
        BinManager binManager = this.config.createBinningContext(null, null, null).getBinManager();
        Assert.assertEquals((long)3L, (long)binManager.getAggregatorCount());
        Assert.assertEquals(AggregatorAverage.class, binManager.getAggregator(0).getClass());
        Assert.assertArrayEquals((Object[])new String[]{"tsm_mean", "tsm_sigma"}, (Object[])binManager.getAggregator(0).getOutputFeatureNames());
        Assert.assertEquals(AggregatorOnMaxSet.class, binManager.getAggregator(1).getClass());
        Assert.assertArrayEquals((Object[])new String[]{"ndvi_max", "ndvi_mjd", "reflec_3", "reflec_7", "reflec_8"}, (Object[])binManager.getAggregator(1).getOutputFeatureNames());
        Assert.assertEquals(AggregatorMinMax.class, binManager.getAggregator(2).getClass());
        Assert.assertArrayEquals((Object[])new String[]{"chl_min", "chl_max"}, (Object[])binManager.getAggregator(2).getOutputFeatureNames());
        Assert.assertArrayEquals((Object[])new String[]{"tsm_mean", "tsm_sigma", "chl_min", "cmax"}, (Object[])binManager.getResultFeatureNames());
        Assert.assertTrue((boolean)binManager.hasPostProcessor());
    }

    @Test
    public void testXmlGeneration() throws BindingException {
        String xml = this.config.toXml();
        BinningConfig configCopy = BinningConfig.fromXml((String)xml);
        Assert.assertEquals((long)this.config.getNumRows(), (long)configCopy.getNumRows());
        Assert.assertEquals((Object)this.config.getCompositingType(), (Object)configCopy.getCompositingType());
        Assert.assertEquals((Object)this.config.getSuperSampling(), (Object)configCopy.getSuperSampling());
        Assert.assertEquals((Object)this.config.getMaskExpr(), (Object)configCopy.getMaskExpr());
        Assert.assertArrayEquals((Object[])this.config.getVariableConfigs(), (Object[])configCopy.getVariableConfigs());
        Assert.assertArrayEquals((Object[])this.config.getAggregatorConfigs(), (Object[])configCopy.getAggregatorConfigs());
        Assert.assertEquals((Object)this.config.getPostProcessorConfig(), (Object)configCopy.getPostProcessorConfig());
    }
}

