/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.PropertySet;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.aggregators.AggregatorOnMaxSet;
import org.esa.snap.binning.cellprocessor.FeatureSelection;
import org.esa.snap.binning.operator.BinningConfig;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.support.PlateCarreeGrid;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BinningConfigTest {
    private static BinningConfig config;

    @BeforeClass
    public static void initBinningConfig() throws Exception {
        config = BinningConfigTest.loadConfig("BinningConfigTest.xml");
    }

    @Test
    public void testPlanetaryGrid_default() {
        PlanetaryGrid grid = config.createPlanetaryGrid();
        Assert.assertEquals((long)4320L, (long)grid.getNumRows());
        Assert.assertEquals(SEAGrid.class, grid.getClass());
    }

    @Test
    public void testPlanetaryGrid_parametrized() {
        BinningConfig localConfig = new BinningConfig();
        PlanetaryGrid grid = localConfig.createPlanetaryGrid();
        Assert.assertEquals((long)2160L, (long)grid.getNumRows());
        Assert.assertEquals(SEAGrid.class, grid.getClass());
        localConfig.setPlanetaryGrid("org.esa.snap.binning.support.PlateCarreeGrid");
        localConfig.setNumRows(2000);
        grid = localConfig.createPlanetaryGrid();
        Assert.assertEquals((long)2000L, (long)grid.getNumRows());
        Assert.assertEquals(PlateCarreeGrid.class, grid.getClass());
    }

    @Test
    public void testCompositingType() throws Exception {
        Assert.assertEquals((Object)CompositingType.MOSAICKING, (Object)config.getCompositingType());
    }

    @Test
    public void testCreateVariableContext() {
        VariableContext variableContext = config.createVariableContext();
        Assert.assertEquals((long)6L, (long)variableContext.getVariableCount());
        Assert.assertEquals((long)0L, (long)variableContext.getVariableIndex("ndvi"));
        Assert.assertEquals((long)1L, (long)variableContext.getVariableIndex("tsm"));
        Assert.assertEquals((long)2L, (long)variableContext.getVariableIndex("reflec_3"));
        Assert.assertEquals((long)3L, (long)variableContext.getVariableIndex("reflec_7"));
        Assert.assertEquals((long)4L, (long)variableContext.getVariableIndex("reflec_8"));
        Assert.assertEquals((long)-1L, (long)variableContext.getVariableIndex("reflec_6"));
        Assert.assertEquals((long)-1L, (long)variableContext.getVariableIndex("reflec_10"));
        Assert.assertEquals((Object)"!l2_flags.INVALID && l2_flags.WATER", (Object)variableContext.getValidMaskExpression());
        Assert.assertEquals((Object)"ndvi", (Object)variableContext.getVariableName(0));
        Assert.assertEquals((Object)"(reflec_10 - reflec_6) / (reflec_10 + reflec_6)", (Object)variableContext.getVariableExpression(0));
        Assert.assertEquals((Object)"reflec_7", (Object)variableContext.getVariableName(3));
        Assert.assertEquals(null, (Object)variableContext.getVariableExpression(3));
    }

    @Test
    public void testCreateBinningContext() {
        BinManager binManager = config.createBinningContext(null, null, null).getBinManager();
        Assert.assertEquals((long)3L, (long)binManager.getAggregatorCount());
        Assert.assertEquals(AggregatorAverage.class, binManager.getAggregator(0).getClass());
        Assert.assertArrayEquals((Object[])new String[]{"tsm_mean", "tsm_sigma"}, (Object[])binManager.getAggregator(0).getOutputFeatureNames());
        Assert.assertEquals(AggregatorOnMaxSet.class, binManager.getAggregator(1).getClass());
        Assert.assertArrayEquals((Object[])new String[]{"ndvi_max", "ndvi_mjd", "reflec_3", "reflec_7", "reflec_8"}, (Object[])binManager.getAggregator(1).getOutputFeatureNames());
        Assert.assertEquals(AggregatorMinMax.class, binManager.getAggregator(2).getClass());
        Assert.assertArrayEquals((Object[])new String[]{"chl_min", "chl_max"}, (Object[])binManager.getAggregator(2).getOutputFeatureNames());
        Assert.assertArrayEquals((Object[])new String[]{"tsm_mean", "tsm_sigma", "ndvi_max", "ndvi_mjd", "reflec_3", "reflec_7", "reflec_8", "chl_min", "chl_max"}, (Object[])binManager.getResultFeatureNames());
        Assert.assertFalse((boolean)binManager.hasPostProcessor());
    }

    @Test
    public void testXmlGeneration() throws BindingException {
        String xml = config.toXml();
        BinningConfig configCopy = BinningConfig.fromXml((String)xml);
        Assert.assertEquals((long)config.getNumRows(), (long)configCopy.getNumRows());
        Assert.assertEquals((Object)config.getCompositingType(), (Object)configCopy.getCompositingType());
        Assert.assertEquals((Object)config.getSuperSampling(), (Object)configCopy.getSuperSampling());
        Assert.assertEquals((Object)config.getMaskExpr(), (Object)configCopy.getMaskExpr());
        Assert.assertArrayEquals((Object[])config.getVariableConfigs(), (Object[])configCopy.getVariableConfigs());
        Assert.assertArrayEquals((Object[])config.getAggregatorConfigs(), (Object[])configCopy.getAggregatorConfigs());
    }

    @Test
    public void testGetNumNumRows_defaultValue() {
        Assert.assertEquals((long)4320L, (long)config.getNumRows());
    }

    @Test
    public void testSetGetMetadataAggregatorName() {
        String aggregatorName = "Willi";
        config.setMetadataAggregatorName("Willi");
        Assert.assertEquals((Object)"Willi", (Object)config.getMetadataAggregatorName());
    }

    @Test
    public void testGetMetadataAggregatorName_defaultValue() {
        Assert.assertEquals((Object)"FIRST_HISTORY", (Object)config.getMetadataAggregatorName());
    }

    @Test
    public void testL3configForCellProcressing() throws Exception {
        BinningConfig binningConfig = BinningConfigTest.loadConfig("l3-cellProcessing.xml");
        Assert.assertNotNull((Object)binningConfig);
        CellProcessorConfig postProcessorConfig = binningConfig.getPostProcessorConfig();
        Assert.assertNotNull((Object)postProcessorConfig);
        Assert.assertSame(FeatureSelection.Config.class, postProcessorConfig.getClass());
        PropertySet propertySet = postProcessorConfig.asPropertySet();
        Assert.assertNotNull((Object)propertySet);
        Object[] properties = propertySet.getProperties();
        Assert.assertEquals((long)2L, (long)properties.length);
        System.out.println("properties = " + Arrays.toString(properties));
        Assert.assertEquals((Object)"Selection", (Object)propertySet.getProperty("type").getValue());
        Object[] expected = new String[]{"tsm_mean", " tsm_sigma", " chl_min", "cmax = chl_max"};
        Object[] actual = (String[])propertySet.getProperty("varNames").getValue();
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testTimeFilterMethod_defaultValue() {
        Assert.assertEquals((Object)BinningOp.TimeFilterMethod.NONE, (Object)config.getTimeFilterMethod());
    }

    static BinningConfig loadConfig(String configPath) throws Exception {
        return BinningConfig.fromXml((String)BinningConfigTest.loadConfigProperties(configPath));
    }

    private static String loadConfigProperties(String configPath) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(BinningConfigTest.class.getResourceAsStream(configPath));){
            String string = FileUtils.readText((Reader)inputStreamReader).trim();
            return string;
        }
    }
}

