/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorOnMaxSet;
import org.esa.snap.binning.aggregators.AggregatorTestUtils;
import org.esa.snap.binning.support.VectorImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatorOnMaxSetTest {
    private BinContext ctx;
    private AggregatorOnMaxSet agg;

    @Before
    public void setUp() throws Exception {
        this.ctx = AggregatorTestUtils.createCtx();
        this.agg = new AggregatorOnMaxSet((VariableContext)new MyVariableContext("a", "b", "c"), "c", "Out", new String[]{"a", "b"});
    }

    @Test
    public void testMetadata() {
        Assert.assertEquals((Object)"ON_MAX_SET", (Object)this.agg.getName());
        Assert.assertEquals((long)4L, (long)this.agg.getSpatialFeatureNames().length);
        Assert.assertEquals((Object)"c_max", (Object)this.agg.getSpatialFeatureNames()[0]);
        Assert.assertEquals((Object)"c_mjd", (Object)this.agg.getSpatialFeatureNames()[1]);
        Assert.assertEquals((Object)"a", (Object)this.agg.getSpatialFeatureNames()[2]);
        Assert.assertEquals((Object)"b", (Object)this.agg.getSpatialFeatureNames()[3]);
        Assert.assertEquals((long)4L, (long)this.agg.getTemporalFeatureNames().length);
        Assert.assertEquals((Object)"c_max", (Object)this.agg.getTemporalFeatureNames()[0]);
        Assert.assertEquals((Object)"c_mjd", (Object)this.agg.getTemporalFeatureNames()[1]);
        Assert.assertEquals((Object)"a", (Object)this.agg.getTemporalFeatureNames()[2]);
        Assert.assertEquals((Object)"b", (Object)this.agg.getTemporalFeatureNames()[3]);
        Assert.assertEquals((long)4L, (long)this.agg.getOutputFeatureNames().length);
        Assert.assertEquals((Object)"Out_max", (Object)this.agg.getOutputFeatureNames()[0]);
        Assert.assertEquals((Object)"Out_mjd", (Object)this.agg.getOutputFeatureNames()[1]);
        Assert.assertEquals((Object)"a", (Object)this.agg.getOutputFeatureNames()[2]);
        Assert.assertEquals((Object)"b", (Object)this.agg.getOutputFeatureNames()[3]);
    }

    @Test
    public void testAggregatorOnMaxSet() {
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        this.agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(3), (float)0.0f);
        this.agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obs(4.0, 7.3f, 0.5f, 1.1f), (WritableVector)svec);
        this.agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obs(5.0, 0.1f, 2.5f, 1.5f), (WritableVector)svec);
        this.agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obs(6.0, 5.5f, 4.9f, 1.4f), (WritableVector)svec);
        Assert.assertEquals((float)1.5f, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.0f, (float)svec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)svec.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)2.5f, (float)svec.get(3), (float)1.0E-5f);
        this.agg.completeSpatial(this.ctx, 3, (WritableVector)svec);
        Assert.assertEquals((float)1.5f, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.0f, (float)svec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)svec.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)2.5f, (float)svec.get(3), (float)1.0E-5f);
        this.agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(3), (float)0.0f);
        this.agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 4.0f, 0.2f, 9.7f), 3, (WritableVector)tvec);
        this.agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(1.1f, 5.0f, 0.1f, 0.3f), 3, (WritableVector)tvec);
        this.agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(4.7f, 6.0f, 0.6f, 7.1f), 3, (WritableVector)tvec);
        Assert.assertEquals((float)4.7f, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)6.0f, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)tvec.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)7.1f, (float)tvec.get(3), (float)1.0E-5f);
        this.agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)4.7f, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)6.0f, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)out.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)7.1f, (float)out.get(3), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorOnMaxSet_AllNaN() {
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        this.agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(3), (float)0.0f);
        this.agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obs(4.0, 7.3f, 0.5f, Float.NaN), (WritableVector)svec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(3), (float)0.0f);
        this.agg.completeSpatial(this.ctx, 3, (WritableVector)svec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)svec.get(3), (float)0.0f);
        this.agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(3), (float)0.0f);
        this.agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN, 4.0f, 0.2f, 9.7f), 3, (WritableVector)tvec);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)tvec.get(3), (float)0.0f);
        this.agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)Float.NaN, (float)out.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)out.get(1), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)out.get(2), (float)0.0f);
        Assert.assertEquals((float)Float.NaN, (float)out.get(3), (float)0.0f);
    }
}

