/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.aggregators.AggregatorTestUtils;
import org.esa.snap.binning.support.VectorImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatorMinMaxTest {
    BinContext ctx;

    @Before
    public void setUp() throws Exception {
        this.ctx = AggregatorTestUtils.createCtx();
    }

    @Test
    public void testMetadata() {
        AggregatorMinMax agg = new AggregatorMinMax((VariableContext)new MyVariableContext("a"), "a", "Out");
        Assert.assertEquals((Object)"MIN_MAX", (Object)agg.getName());
        Assert.assertEquals((long)2L, (long)agg.getSpatialFeatureNames().length);
        Assert.assertEquals((Object)"a_min", (Object)agg.getSpatialFeatureNames()[0]);
        Assert.assertEquals((Object)"a_max", (Object)agg.getSpatialFeatureNames()[1]);
        Assert.assertEquals((long)2L, (long)agg.getTemporalFeatureNames().length);
        Assert.assertEquals((Object)"a_min", (Object)agg.getTemporalFeatureNames()[0]);
        Assert.assertEquals((Object)"a_max", (Object)agg.getTemporalFeatureNames()[1]);
        Assert.assertEquals((long)2L, (long)agg.getOutputFeatureNames().length);
        Assert.assertEquals((Object)"Out_min", (Object)agg.getOutputFeatureNames()[0]);
        Assert.assertEquals((Object)"Out_max", (Object)agg.getOutputFeatureNames()[1]);
    }

    @Test
    public void tesAggregatorMinMax() {
        AggregatorMinMax agg = new AggregatorMinMax((VariableContext)new MyVariableContext("a"), "a", "Out");
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(7.3f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(5.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(-0.1f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.0f), (WritableVector)svec);
        Assert.assertEquals((float)-0.1f, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)7.3f, (float)svec.get(1), (float)1.0E-5f);
        agg.completeSpatial(this.ctx, 3, (WritableVector)svec);
        Assert.assertEquals((float)-0.1f, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)7.3f, (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)tvec.get(1), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.9f, 1.0f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 5.1f), 5, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.6f, 2.0f), 9, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 1.5f), 2, (WritableVector)tvec);
        Assert.assertEquals((float)0.1f, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.1f, (float)tvec.get(1), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)0.1f, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.1f, (float)tvec.get(1), (float)1.0E-5f);
    }
}

