/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorAverageML;
import org.esa.snap.binning.aggregators.AggregatorTestUtils;
import org.esa.snap.binning.support.VectorImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatorAverageMLTest {
    BinContext ctx;

    @Before
    public void setUp() throws Exception {
        this.ctx = AggregatorTestUtils.createCtx();
    }

    @Test
    public void testMetadata_noSums() {
        AggregatorAverageML agg = new AggregatorAverageML((VariableContext)new MyVariableContext("b"), "b", "b", 0.5, false);
        Assert.assertEquals((Object)"AVG_ML", (Object)agg.getName());
        Assert.assertEquals((long)2L, (long)agg.getSpatialFeatureNames().length);
        Assert.assertEquals((Object)"b_sum", (Object)agg.getSpatialFeatureNames()[0]);
        Assert.assertEquals((Object)"b_sum_sq", (Object)agg.getSpatialFeatureNames()[1]);
        Assert.assertEquals((long)3L, (long)agg.getTemporalFeatureNames().length);
        Assert.assertEquals((Object)"b_sum", (Object)agg.getTemporalFeatureNames()[0]);
        Assert.assertEquals((Object)"b_sum_sq", (Object)agg.getTemporalFeatureNames()[1]);
        Assert.assertEquals((Object)"b_weights", (Object)agg.getTemporalFeatureNames()[2]);
        Assert.assertEquals((long)4L, (long)agg.getOutputFeatureNames().length);
        Assert.assertEquals((Object)"b_mean", (Object)agg.getOutputFeatureNames()[0]);
        Assert.assertEquals((Object)"b_sigma", (Object)agg.getOutputFeatureNames()[1]);
        Assert.assertEquals((Object)"b_median", (Object)agg.getOutputFeatureNames()[2]);
        Assert.assertEquals((Object)"b_mode", (Object)agg.getOutputFeatureNames()[3]);
    }

    @Test
    public void testMetadata_withSums() {
        AggregatorAverageML agg = new AggregatorAverageML((VariableContext)new MyVariableContext("b"), "b", "b", 0.5, true);
        Assert.assertEquals((Object)"AVG_ML", (Object)agg.getName());
        Assert.assertEquals((long)2L, (long)agg.getSpatialFeatureNames().length);
        Assert.assertEquals((Object)"b_sum", (Object)agg.getSpatialFeatureNames()[0]);
        Assert.assertEquals((Object)"b_sum_sq", (Object)agg.getSpatialFeatureNames()[1]);
        Assert.assertEquals((long)3L, (long)agg.getTemporalFeatureNames().length);
        Assert.assertEquals((Object)"b_sum", (Object)agg.getTemporalFeatureNames()[0]);
        Assert.assertEquals((Object)"b_sum_sq", (Object)agg.getTemporalFeatureNames()[1]);
        Assert.assertEquals((Object)"b_weights", (Object)agg.getTemporalFeatureNames()[2]);
        Assert.assertEquals((long)3L, (long)agg.getOutputFeatureNames().length);
        Assert.assertEquals((Object)"b_sum", (Object)agg.getOutputFeatureNames()[0]);
        Assert.assertEquals((Object)"b_sum_sq", (Object)agg.getOutputFeatureNames()[1]);
        Assert.assertEquals((Object)"b_weights", (Object)agg.getOutputFeatureNames()[2]);
    }

    @Test
    public void testAggregatorAverageML() {
        AggregatorAverageML agg = new AggregatorAverageML((VariableContext)new MyVariableContext("b"), "b", 0.5);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        Assert.assertEquals((double)(Math.log(1.5) + Math.log(2.5) + Math.log(0.5)), (double)svec.get(0), (double)1.0E-5);
        Assert.assertEquals((double)(Math.log(1.5) * Math.log(1.5) + Math.log(2.5) * Math.log(2.5) + Math.log(0.5) * Math.log(0.5)), (double)svec.get(1), (double)1.0E-5f);
        agg.completeSpatial(this.ctx, 3, (WritableVector)svec);
        Assert.assertEquals((double)((Math.log(1.5) + Math.log(2.5) + Math.log(0.5)) / Math.sqrt(3.0)), (double)svec.get(0), (double)1.0E-5f);
        Assert.assertEquals((double)((Math.log(1.5) * Math.log(1.5) + Math.log(2.5) * Math.log(2.5) + Math.log(0.5) * Math.log(0.5)) / Math.sqrt(3.0)), (double)svec.get(1), (double)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 0.04f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        Assert.assertEquals((double)0.7000000476837158, (double)tvec.get(0), (double)1.0E-5);
        Assert.assertEquals((double)0.15f, (double)tvec.get(1), (double)1.0E-5);
        Assert.assertEquals((double)(Math.sqrt(3.0) + Math.sqrt(2.0) + Math.sqrt(1.0) + Math.sqrt(7.0)), (double)tvec.get(2), (double)1.0E-5);
        agg.completeTemporal(this.ctx, 4, (WritableVector)tvec);
        float mean = 1.114932f;
        float sigma = 0.119713f;
        float median = 1.10856f;
        float mode = 1.095926f;
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)mean, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sigma, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)median, (float)out.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)mode, (float)out.get(3), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageML_WithSums() {
        AggregatorAverageML agg = new AggregatorAverageML((VariableContext)new MyVariableContext("b"), "b", "b", 0.5, true);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        double sumX = Math.log(1.5) + Math.log(2.5) + Math.log(0.5);
        double sumXX = Math.log(1.5) * Math.log(1.5) + Math.log(2.5) * Math.log(2.5) + Math.log(0.5) * Math.log(0.5);
        Assert.assertEquals((double)sumX, (double)svec.get(0), (double)1.0E-5);
        Assert.assertEquals((double)sumXX, (double)svec.get(1), (double)1.0E-5f);
        agg.completeSpatial(this.ctx, 3, (WritableVector)svec);
        Assert.assertEquals((double)((Math.log(1.5) + Math.log(2.5) + Math.log(0.5)) / Math.sqrt(3.0)), (double)svec.get(0), (double)1.0E-5f);
        Assert.assertEquals((double)((Math.log(1.5) * Math.log(1.5) + Math.log(2.5) * Math.log(2.5) + Math.log(0.5) * Math.log(0.5)) / Math.sqrt(3.0)), (double)svec.get(1), (double)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 0.04f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        sumX = 0.7000000476837158;
        sumXX = 0.15f;
        double sumW = Math.sqrt(3.0) + Math.sqrt(2.0) + Math.sqrt(1.0) + Math.sqrt(7.0);
        Assert.assertEquals((double)sumX, (double)tvec.get(0), (double)1.0E-5);
        Assert.assertEquals((double)sumXX, (double)tvec.get(1), (double)1.0E-5);
        Assert.assertEquals((double)sumW, (double)tvec.get(2), (double)1.0E-5);
        agg.completeTemporal(this.ctx, 4, (WritableVector)tvec);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((double)sumX, (double)out.get(0), (double)1.0E-5);
        Assert.assertEquals((double)sumXX, (double)out.get(1), (double)1.0E-5);
        Assert.assertEquals((double)sumW, (double)out.get(2), (double)1.0E-5);
    }
}

