/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.MyBinManager;
import org.esa.snap.binning.MyPlanetaryGrid;
import org.esa.snap.binning.MySpatialBinConsumer;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.SpatialBinConsumer;
import org.esa.snap.binning.SpatialBinner;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.aggregators.AggregatorAverageML;
import org.esa.snap.binning.support.BinningContextImpl;
import org.esa.snap.binning.support.ObservationImpl;
import org.esa.snap.binning.support.SEAGrid;
import org.junit.Assert;
import org.junit.Test;

public class SpatialBinnerTest {
    static final int SUM_X = 0;
    static final int SUM_XX = 1;
    static final int WEIGHT = 2;

    @Test
    public void testThatObservationsAreAggregated() throws Exception {
        MyPlanetaryGrid planetaryGrid = new MyPlanetaryGrid();
        MyVariableContext variableContext = new MyVariableContext("x");
        MyBinManager binManager = new MyBinManager(variableContext, new Aggregator[]{new AggregatorAverageML((VariableContext)variableContext, "x", 0.5)});
        BinningContextImpl binningContext = new BinningContextImpl((PlanetaryGrid)planetaryGrid, (BinManager)binManager, CompositingType.BINNING, 1, null, null);
        MySpatialBinConsumer mySpatialBinProcessor = new MySpatialBinConsumer(binManager);
        SpatialBinner spatialBinner = new SpatialBinner((BinningContext)binningContext, (SpatialBinConsumer)mySpatialBinProcessor);
        spatialBinner.processObservationSlice(new Observation[]{new ObservationImpl(0.0, 1.1, 0.0, new float[]{1.1f}), new ObservationImpl(0.0, 1.1, 0.0, new float[]{1.2f}), new ObservationImpl(0.0, 2.1, 0.0, new float[]{1.3f}), new ObservationImpl(0.0, 2.1, 0.0, new float[]{1.4f})});
        spatialBinner.processObservationSlice(new Observation[]{new ObservationImpl(0.0, 1.1, 0.0, new float[]{2.1f}), new ObservationImpl(0.0, 2.1, 0.0, new float[]{2.2f}), new ObservationImpl(0.0, 2.1, 0.0, new float[]{2.3f}), new ObservationImpl(0.0, 2.1, 0.0, new float[]{2.4f}), new ObservationImpl(0.0, 3.1, 0.0, new float[]{2.5f})});
        spatialBinner.complete();
        Map<Long, TemporalBin> binMap = mySpatialBinProcessor.binMap;
        Assert.assertEquals((long)3L, (long)binMap.size());
        TemporalBin tbin1 = binMap.get(1L);
        Assert.assertNotNull((Object)tbin1);
        Assert.assertEquals((long)3L, (long)tbin1.getNumObs());
        Assert.assertEquals((long)1L, (long)tbin1.getNumPasses());
        Vector agg1 = binManager.getTemporalVector(tbin1, 0);
        Assert.assertNotNull((Object)agg1);
        Assert.assertEquals((double)Math.sqrt(3.0), (double)agg1.get(2), (double)1.0E-5);
        Assert.assertEquals((double)((Math.log(1.1) + Math.log(1.2) + Math.log(2.1)) / Math.sqrt(3.0)), (double)agg1.get(0), (double)1.0E-5);
        TemporalBin tbin2 = binMap.get(2L);
        Assert.assertNotNull((Object)tbin2);
        Assert.assertEquals((long)5L, (long)tbin2.getNumObs());
        Assert.assertEquals((long)1L, (long)tbin2.getNumPasses());
        Vector agg2 = binManager.getTemporalVector(tbin2, 0);
        Assert.assertNotNull((Object)agg2);
        Assert.assertEquals((double)Math.sqrt(5.0), (double)agg2.get(2), (double)1.0E-5);
        Assert.assertEquals((double)((Math.log(1.3) + Math.log(1.4) + Math.log(2.2) + Math.log(2.3) + Math.log(2.4)) / Math.sqrt(5.0)), (double)agg2.get(0), (double)1.0E-5);
        TemporalBin tbin3 = binMap.get(3L);
        Assert.assertNotNull((Object)tbin3);
        Assert.assertEquals((long)1L, (long)tbin3.getNumObs());
        Assert.assertEquals((long)1L, (long)tbin3.getNumPasses());
        Vector agg3 = binManager.getTemporalVector(tbin3, 0);
        Assert.assertNotNull((Object)agg3);
        Assert.assertEquals((double)1.0, (double)agg3.get(2), (double)1.0E-10);
        Assert.assertEquals((double)Math.log(2.5), (double)agg3.get(0), (double)1.0E-5);
    }

    @Test
    public void testThatCellsAreDeterminedCorrectly() throws Exception {
        SEAGrid planetaryGrid = new SEAGrid();
        double binEdgeSize = 180.0 / (double)planetaryGrid.getNumRows();
        int pixelsPerBinEdge = 4;
        double pixelEdgeSize = binEdgeSize / (double)pixelsPerBinEdge;
        int w = 16;
        int h = 16;
        double rotAngle = 0.0;
        double lonRange = (double)w * pixelEdgeSize;
        double latRange = (double)h * pixelEdgeSize;
        ObservationImpl[][] pixelSlices = new ObservationImpl[h][w];
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(rotAngle));
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double lat = 0.5 * pixelEdgeSize + latRange * ((double)j / (double)h - 0.5);
                double lon = 0.5 * pixelEdgeSize + lonRange * ((double)i / (double)w - 0.5);
                double[] srcPts = new double[]{lat, lon};
                double[] dstPts = new double[2];
                at.transform(srcPts, 0, dstPts, 0, 1);
                pixelSlices[j][i] = new ObservationImpl(dstPts[0], dstPts[1], 0.0, new float[]{0.0f});
            }
        }
        MyVariableContext variableContext = new MyVariableContext("x");
        MyBinManager binManager = new MyBinManager(variableContext, new Aggregator[]{new AggregatorAverageML((VariableContext)variableContext, "x", 0.5)});
        TestSpatialBinConsumer spatialBinProcessor = new TestSpatialBinConsumer();
        BinningContextImpl binningContext = new BinningContextImpl((PlanetaryGrid)planetaryGrid, (BinManager)binManager, CompositingType.BINNING, 1, null, null);
        SpatialBinner spatialBinner = new SpatialBinner((BinningContext)binningContext, (SpatialBinConsumer)spatialBinProcessor);
        for (ObservationImpl[] pixelSlice : pixelSlices) {
            spatialBinner.processObservationSlice((Observation[])pixelSlice);
        }
        spatialBinner.complete();
        ArrayList<SpatialBin> producedSpatialBins = binManager.producedSpatialBins;
        int numObs = w * h;
        Assert.assertEquals((long)256L, (long)numObs);
        Assert.assertEquals((long)256L, (long)spatialBinProcessor.numObservationsTotal);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((String)String.format("Problem with bin[%d]", i), (long)16L, (long)producedSpatialBins.get(i).getNumObs());
        }
        int numBins = w * h / (pixelsPerBinEdge * pixelsPerBinEdge);
        Assert.assertEquals((long)16L, (long)numBins);
        Assert.assertEquals((long)16L, (long)producedSpatialBins.size());
        int[] expectedIndexes = new int[]{2976689, 2976690, 2976691, 2976692, 2972369, 2972370, 2972371, 2972372, 2968049, 2968050, 2968051, 2968052, 2963729, 2963730, 2963731, 2963732};
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((String)String.format("Problem with bin[%d]", i), (long)expectedIndexes[i], (long)producedSpatialBins.get(i).getIndex());
        }
    }

    private static class BinComparator
    implements Comparator<SpatialBin> {
        private BinComparator() {
        }

        @Override
        public int compare(SpatialBin b1, SpatialBin b2) {
            return (int)(b1.getIndex() - b2.getIndex());
        }
    }

    private static class TestSpatialBinConsumer
    implements SpatialBinConsumer {
        int numObservationsTotal;
        boolean verbous = false;
        int sliceIndex;

        private TestSpatialBinConsumer() {
        }

        public void consumeSpatialBins(BinningContext binningContext, List<SpatialBin> sliceBins) {
            if (this.verbous) {
                Collections.sort(sliceBins, new BinComparator());
                System.out.println("Slice  " + this.sliceIndex + " =================");
            }
            for (SpatialBin bin : sliceBins) {
                if (this.verbous) {
                    System.out.println("  writing " + bin.getIndex() + " with " + bin.getNumObs() + " obs.");
                }
                this.numObservationsTotal += bin.getNumObs();
            }
            ++this.sliceIndex;
        }
    }
}

