/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorAverageML;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.support.ObservationImpl;
import org.junit.Assert;
import org.junit.Test;

public class SpatialBinTest {
    @Test
    public void testIllegalConstructorCalls() {
        try {
            new SpatialBin(0L, -1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLegalConstructorCalls() {
        SpatialBin bin = new SpatialBin(42L, 0);
        Assert.assertEquals((long)42L, (long)bin.getIndex());
        bin = new SpatialBin(43L, 3);
        Assert.assertEquals((long)43L, (long)bin.getIndex());
    }

    @Test
    public void testBinAggregationAndIO() throws IOException {
        MyVariableContext variableContext = new MyVariableContext("A", "B", "C");
        BinManager bman = new BinManager((VariableContext)variableContext, new Aggregator[]{new AggregatorMinMax((VariableContext)variableContext, "A", "A"), new AggregatorAverage((VariableContext)variableContext, "B", "B", 0.0, false, false), new AggregatorAverageML((VariableContext)variableContext, "C", "C", 0.5, false)});
        SpatialBin bin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.2f, 4.0f, 4.0f}), bin);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.6f, 2.0f, 2.0f}), bin);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.4f, 6.0f, 6.0f}), bin);
        Assert.assertEquals((long)3L, (long)bin.getNumObs());
        Vector agg1 = bman.getSpatialVector(bin, 0);
        Vector agg2 = bman.getSpatialVector(bin, 1);
        Vector agg3 = bman.getSpatialVector(bin, 2);
        Assert.assertEquals((long)2L, (long)agg1.size());
        Assert.assertEquals((float)0.2f, (float)agg1.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)agg1.get(1), (float)1.0E-5f);
        Assert.assertEquals((long)2L, (long)agg2.size());
        Assert.assertEquals((float)12.0f, (float)agg2.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)56.0f, (float)agg2.get(1), (float)1.0E-5f);
        Assert.assertEquals((long)2L, (long)agg3.size());
        Assert.assertEquals((float)3.871201f, (float)agg3.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.612667f, (float)agg3.get(1), (float)1.0E-5f);
        bman.completeSpatialBin(bin);
        Assert.assertEquals((float)0.2f, (float)agg1.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)agg1.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)4.0f, (float)agg2.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)18.666668f, (float)agg2.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)2.235039f, (float)agg3.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)3.240475f, (float)agg3.get(1), (float)1.0E-5f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bin.write((DataOutput)new DataOutputStream(baos));
        byte[] bytes = baos.toByteArray();
        SpatialBin binCopy = SpatialBin.read((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        Assert.assertEquals((long)-1L, (long)binCopy.getIndex());
        Assert.assertEquals((long)3L, (long)binCopy.getNumObs());
        Vector agg1Copy = bman.getSpatialVector(binCopy, 0);
        Vector agg2Copy = bman.getSpatialVector(binCopy, 1);
        Vector agg3Copy = bman.getSpatialVector(binCopy, 2);
        Assert.assertEquals((long)2L, (long)agg1Copy.size());
        Assert.assertEquals((float)0.2f, (float)agg1Copy.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)agg1Copy.get(1), (float)1.0E-5f);
        Assert.assertEquals((long)2L, (long)agg2Copy.size());
        Assert.assertEquals((float)4.0f, (float)agg2Copy.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)18.666668f, (float)agg2Copy.get(1), (float)1.0E-5f);
        Assert.assertEquals((long)2L, (long)agg3Copy.size());
        Assert.assertEquals((float)2.235039f, (float)agg3Copy.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)3.240475f, (float)agg3Copy.get(1), (float)1.0E-5f);
    }

    @Test
    public void testBinContext() {
        SpatialBin ctx = new SpatialBin(0L, 0);
        Assert.assertEquals(null, (Object[])((Object[])ctx.get("a")));
        ctx.put("a", (Object)42);
        Assert.assertEquals((long)42L, (long)((Integer)ctx.get("a")).intValue());
    }

    @Test
    public void testToString() {
        SpatialBin bin = new SpatialBin(0L, 0);
        Assert.assertEquals((Object)"SpatialBin{index=0, numObs=0, featureValues=[]}", (Object)bin.toString());
        bin = new SpatialBin(42L, 2);
        Assert.assertEquals((Object)"SpatialBin{index=42, numObs=0, featureValues=[0.0, 0.0]}", (Object)bin.toString());
        bin.setNumObs(13);
        Assert.assertEquals((Object)"SpatialBin{index=42, numObs=13, featureValues=[0.0, 0.0]}", (Object)bin.toString());
        bin.featureValues[0] = 56.7f;
        bin.featureValues[1] = 8.9f;
        Assert.assertEquals((Object)"SpatialBin{index=42, numObs=13, featureValues=[56.7, 8.9]}", (Object)bin.toString());
    }

    @Test
    public void testBinCreationWithIndex() throws Exception {
        SpatialBin bin = SpatialBin.read((long)10L, (DataInput)new DataInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        }));
        Assert.assertEquals((long)10L, (long)bin.getIndex());
    }
}

