/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.SpatialBinConsumer;
import org.esa.snap.binning.TemporalBin;

class MySpatialBinConsumer
implements SpatialBinConsumer {
    private final BinManager binManager;
    final Map<Long, TemporalBin> binMap;

    MySpatialBinConsumer(BinManager binManager) {
        this.binManager = binManager;
        this.binMap = new HashMap<Long, TemporalBin>();
    }

    public void consumeSpatialBins(BinningContext binningContext, List<SpatialBin> sliceBins) {
        for (SpatialBin spatialBin : sliceBins) {
            TemporalBin temporalBin = this.binMap.get(spatialBin.getIndex());
            if (temporalBin == null) {
                temporalBin = this.binManager.createTemporalBin(spatialBin.getIndex());
            }
            binningContext.getBinManager().aggregateTemporalBin(spatialBin, temporalBin);
            this.binMap.put(temporalBin.getIndex(), temporalBin);
        }
    }
}

