/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.io.IOException;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.cellprocessor.FeatureSelection;
import org.esa.snap.binning.support.ObservationImpl;
import org.junit.Assert;
import org.junit.Test;

public class CellProcessorTest {
    @Test
    public void testBinningWithoutPostProcessor() throws IOException {
        MyVariableContext variableContext = new MyVariableContext("A");
        BinManager bman = new BinManager((VariableContext)variableContext, new Aggregator[]{new AggregatorMinMax((VariableContext)variableContext, "A", "out")});
        TemporalBin tbin = this.doBinning(bman);
        Assert.assertEquals((long)2L, (long)tbin.getFeatureValues().length);
        WritableVector resultVector = tbin.toVector();
        Assert.assertEquals((long)2L, (long)resultVector.size());
        Assert.assertEquals((double)0.2f, (double)resultVector.get(0), (double)1.0E-4);
        Assert.assertEquals((double)0.6f, (double)resultVector.get(1), (double)1.0E-4);
        Assert.assertArrayEquals((Object[])new String[]{"out_min", "out_max"}, (Object[])bman.getResultFeatureNames());
    }

    @Test
    public void testBinningWithPostProcessor() throws IOException {
        MyVariableContext variableContext = new MyVariableContext("A");
        AggregatorMinMax aggregator = new AggregatorMinMax((VariableContext)variableContext, "A", "out");
        FeatureSelection.Config ppSelection = new FeatureSelection.Config(new String[]{"out_max"});
        BinManager bman = new BinManager((VariableContext)variableContext, (CellProcessorConfig)ppSelection, new Aggregator[]{aggregator});
        TemporalBin tbin = this.doBinning(bman);
        Assert.assertEquals((long)2L, (long)tbin.getFeatureValues().length);
        WritableVector temporalVector = tbin.toVector();
        int postProcessFeatureCount = bman.getPostProcessFeatureCount();
        TemporalBin processedBin = new TemporalBin(tbin.getIndex(), postProcessFeatureCount);
        WritableVector processedVector = processedBin.toVector();
        bman.postProcess((Vector)temporalVector, processedVector);
        WritableVector resultVector = processedBin.toVector();
        Assert.assertEquals((long)1L, (long)resultVector.size());
        Assert.assertEquals((double)0.6f, (double)resultVector.get(0), (double)1.0E-4);
        Assert.assertArrayEquals((Object[])new String[]{"out_max"}, (Object[])bman.getResultFeatureNames());
    }

    private TemporalBin doBinning(BinManager bman) {
        TemporalBin tbin = bman.createTemporalBin(0L);
        SpatialBin sbin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.2f}), sbin);
        bman.completeSpatialBin(sbin);
        bman.aggregateTemporalBin(sbin, tbin);
        sbin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.6f}), sbin);
        bman.completeSpatialBin(sbin);
        bman.aggregateTemporalBin(sbin, tbin);
        sbin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.4f}), sbin);
        bman.completeSpatialBin(sbin);
        bman.aggregateTemporalBin(sbin, tbin);
        bman.completeTemporalBin(tbin);
        Assert.assertEquals((long)3L, (long)tbin.getNumObs());
        Vector tVec = bman.getTemporalVector(tbin, 0);
        Assert.assertEquals((long)2L, (long)tVec.size());
        Assert.assertEquals((float)0.2f, (float)tVec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)tVec.get(1), (float)1.0E-5f);
        return tbin;
    }
}

