/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import org.esa.beam.binning.support.AbstractGaussianGrid;

public final class RegularGaussianGrid
extends AbstractGaussianGrid {
    public RegularGaussianGrid(int numRows) {
        super(numRows);
    }

    @Override
    public int getRowIndex(long binIndex) {
        return (int)(binIndex / (long)this.getConfig().getRegularColumnCount());
    }

    @Override
    public long getNumBins() {
        return this.getNumRows() * this.getConfig().getRegularColumnCount();
    }

    @Override
    protected long getFirstBinIndexUnchecked(int rowIndex) {
        return rowIndex * this.getNumCols(rowIndex);
    }

    @Override
    protected int getNumColsUnchecked(int rowIndex) {
        return this.getConfig().getRegularColumnCount();
    }

    @Override
    protected double getCenterLon(int rowIndex, int colIndex) {
        return this.getConfig().getRegularLongitudePoints()[colIndex];
    }
}

