/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import java.util.Arrays;
import org.esa.beam.binning.Vector;

public final class GrowableVector
implements Vector {
    private float[] elements;
    private int size;

    public GrowableVector(int capacity) {
        this.elements = new float[capacity];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float get(int index) {
        return this.elements[index];
    }

    public float[] getElements() {
        return Arrays.copyOfRange(this.elements, 0, this.size);
    }

    public void add(float element) {
        if (this.size >= this.elements.length) {
            float[] temp = new float[this.elements.length * 3 / 2 + 2];
            System.arraycopy(this.elements, 0, temp, 0, this.size);
            this.elements = temp;
        }
        this.elements[this.size++] = element;
    }

    public String toString() {
        return Arrays.toString(this.getElements());
    }
}

