/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.reader;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;

class VariableReader {
    private final Variable binVariable;
    private final int layer;
    private int maxExtent;

    VariableReader(Variable binVariable) {
        this.binVariable = binVariable;
        this.layer = -1;
    }

    VariableReader(Variable binVariable, int layer) {
        this.binVariable = binVariable;
        this.layer = layer;
        this.maxExtent = binVariable.getDimension(0).getLength();
    }

    Variable getBinVariable() {
        return this.binVariable;
    }

    Array readFully() throws IOException {
        if (this.layer < 0) {
            return this.binVariable.read();
        }
        try {
            int[] origin = new int[]{0, this.layer};
            int[] shape = new int[]{this.maxExtent, 1};
            return this.binVariable.read(origin, shape);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    Array read(int[] origin, int[] shape) throws IOException {
        try {
            if (this.layer < 0) {
                return this.binVariable.read(origin, shape);
            }
            int[] originFull = new int[]{origin[0], this.layer};
            int[] shapeFull = new int[]{shape[0], 1};
            return this.binVariable.read(originFull, shapeFull);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }
}

