/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.reader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.esa.beam.binning.reader.CacheEntry;
import org.esa.beam.framework.datamodel.Band;

class NcArrayCache {
    private final Map<Band, CacheEntry> cache = new HashMap<Band, CacheEntry>();
    private final Timer timer = new Timer();

    NcArrayCache() {
        TimerTask clearCacheTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long expired = System.currentTimeMillis() - 2000L;
                Map map = NcArrayCache.this.cache;
                synchronized (map) {
                    Iterator iterator = NcArrayCache.this.cache.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (((CacheEntry)iterator.next().getValue()).getLastAccess() >= expired) continue;
                        iterator.remove();
                    }
                }
            }
        };
        this.timer.schedule(clearCacheTask, 2000L, 2000L);
    }

    void dispose() {
        this.cache.clear();
        this.timer.cancel();
    }

    public CacheEntry get(Band destBand) {
        return this.cache.get(destBand);
    }

    public void put(Band destBand, CacheEntry cacheEntry) {
        this.cache.put(destBand, cacheEntry);
    }
}

