/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.ui;

import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.Grid;
import com.bc.ceres.swing.ListControlBar;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.esa.beam.binning.operator.VariableConfig;
import org.esa.beam.binning.operator.ui.BinningFormModel;
import org.esa.beam.binning.operator.ui.VariableItem;
import org.esa.beam.binning.operator.ui.VariableItemDialog;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;

class VariableTableController
extends ListControlBar.AbstractListController {
    final Grid grid;
    private final BinningFormModel binningFormModel;
    private final List<VariableItem> variableItems;

    VariableTableController(Grid grid, BinningFormModel binningFormModel) {
        this.grid = grid;
        this.binningFormModel = binningFormModel;
        this.variableItems = new ArrayList<VariableItem>();
        this.addVariableConfigs(this.binningFormModel.getVariableConfigs());
    }

    public boolean addRow(int index) {
        return this.editVariableItem(new VariableItem(), -1);
    }

    public boolean removeRows(int[] indices) {
        this.grid.removeDataRows(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.variableItems.remove(indices[i]);
        }
        this.updateBinningFormModel();
        return true;
    }

    public boolean moveRowUp(int index) {
        this.grid.moveDataRowUp(index);
        VariableItem vi1 = this.variableItems.get(index - 1);
        VariableItem vi2 = this.variableItems.get(index);
        this.variableItems.set(index - 1, vi2);
        this.variableItems.set(index, vi1);
        this.updateBinningFormModel();
        return true;
    }

    public boolean moveRowDown(int index) {
        this.grid.moveDataRowDown(index);
        VariableItem vi1 = this.variableItems.get(index);
        VariableItem vi2 = this.variableItems.get(index + 1);
        this.variableItems.set(index, vi2);
        this.variableItems.set(index + 1, vi1);
        this.updateBinningFormModel();
        return true;
    }

    public void updateState(ListControlBar listControlBar) {
    }

    void setVariableConfigs(VariableConfig[] variableConfigs) {
        this.clearGrid();
        this.variableItems.clear();
        this.addVariableConfigs(variableConfigs);
        this.updateBinningFormModel();
    }

    private void addDataRow(VariableItem vi) {
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        JLabel nameLabel = new JLabel(vi.variableConfig.getName());
        nameLabel.setBorder(emptyBorder);
        JLabel exprLabel = new JLabel(vi.variableConfig.getExpr());
        exprLabel.setBorder(emptyBorder);
        final AbstractButton editButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/beam/resources/images/icons/Edit16.gif"), (boolean)false);
        editButton.setRolloverEnabled(true);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = VariableTableController.this.grid.findDataRowIndex((JComponent)editButton);
                VariableTableController.this.editVariableItem((VariableItem)VariableTableController.this.variableItems.get(rowIndex), rowIndex);
            }
        });
        this.grid.addDataRow(new JComponent[]{nameLabel, exprLabel, editButton});
        this.variableItems.add(vi);
    }

    private boolean editVariableItem(VariableItem variableItem, int rowIndex) {
        boolean newVariable;
        Product contextProduct = this.binningFormModel.getContextProduct();
        if (contextProduct == null) {
            JOptionPane.showMessageDialog((Component)this.grid, "At least one source product must be set first");
            return false;
        }
        boolean bl = newVariable = rowIndex == -1;
        if (newVariable) {
            String varName;
            int newVarIndex = this.variableItems.size();
            while (contextProduct.containsRasterDataNode(varName = "variable_" + newVarIndex++)) {
            }
            variableItem.variableConfig.setName(varName);
        }
        String oldVarName = variableItem.variableConfig.getName();
        VariableItemDialog variableItemDialog = new VariableItemDialog(SwingUtilities.getWindowAncestor((Component)this.grid), variableItem, newVariable, contextProduct);
        if (variableItemDialog.show() == 1) {
            if (newVariable) {
                this.addDataRow(variableItem);
            } else {
                this.updateDataRow(variableItem, rowIndex);
                if (!oldVarName.equals(variableItem.variableConfig.getName())) {
                    this.updateVariableExpressions(oldVarName, variableItem.variableConfig.getName());
                }
            }
            this.updateBinningFormModel();
            return true;
        }
        return false;
    }

    private void updateVariableExpressions(String oldVarName, String newVarName) {
        for (int i = 0; i < this.variableItems.size(); ++i) {
            VariableItem updatedItem = this.variableItems.get(i);
            VariableConfig updatedVarConfig = updatedItem.variableConfig;
            if (!updatedVarConfig.getExpr().contains(oldVarName)) continue;
            String updatedExpr = updatedVarConfig.getExpr().replace(oldVarName, newVarName);
            updatedVarConfig.setExpr(updatedExpr);
            this.updateDataRow(updatedItem, i);
        }
    }

    private void updateBinningFormModel() {
        VariableConfig[] variableConfigs = new VariableConfig[this.variableItems.size()];
        for (int i = 0; i < this.variableItems.size(); ++i) {
            VariableItem variableItem = this.variableItems.get(i);
            variableConfigs[i] = variableItem.variableConfig;
        }
        try {
            this.binningFormModel.setVariableConfigs(variableConfigs);
        }
        catch (ValidationException e) {
            JOptionPane.showMessageDialog((Component)this.grid, e.getMessage(), "Aggregator Configuration", 0);
        }
    }

    private void clearGrid() {
        int[] rowIndices = new int[this.grid.getDataRowCount()];
        for (int i = 0; i < rowIndices.length; ++i) {
            rowIndices[i] = i;
        }
        this.removeRows(rowIndices);
    }

    private void updateDataRow(VariableItem variableItem, int rowIndex) {
        JComponent[] components = this.grid.getDataRow(rowIndex);
        ((JLabel)components[0]).setText(variableItem.variableConfig.getName());
        ((JLabel)components[1]).setText(variableItem.variableConfig.getExpr());
    }

    private void addVariableConfigs(VariableConfig[] variableConfigs) {
        for (VariableConfig variableConfig : variableConfigs) {
            this.addDataRow(new VariableItem(variableConfig));
        }
    }
}

