/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.metadata;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.esa.beam.binning.operator.BinningOp;
import org.esa.beam.binning.operator.metadata.GlobalMetaParameter;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.descriptor.OperatorDescriptor;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.io.FileUtils;

public class GlobalMetadata {
    private static final String DATETIME_OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final SortedMap<String, String> metaProperties = new TreeMap<String, String>();

    public static GlobalMetadata create(GlobalMetaParameter parameter) {
        return new GlobalMetadata(parameter);
    }

    public void processMetadataTemplates(File metadataTemplateDir, BinningOp operator, Product targetProduct, Logger logger) {
        File absTemplateDir = metadataTemplateDir.getAbsoluteFile();
        File[] files = absTemplateDir.listFiles(new VelocityTemplateFilter());
        if (files == null || files.length == 0) {
            return;
        }
        VelocityEngine ve = GlobalMetadata.createVelocityEngine(absTemplateDir, logger);
        if (ve == null) {
            return;
        }
        VelocityContext vc = new VelocityContext(this.metaProperties);
        vc.put("operator", (Object)operator);
        vc.put("targetProduct", (Object)targetProduct);
        vc.put("metadataProperties", this.metaProperties);
        for (File file : files) {
            GlobalMetadata.processMetadataTemplate(file, ve, vc, logger);
        }
    }

    public SortedMap<String, String> asSortedMap() {
        return this.metaProperties;
    }

    public MetadataElement asMetadataElement() {
        MetadataElement globalAttributes = new MetadataElement("Global_Attributes");
        for (String name : this.metaProperties.keySet()) {
            String value = (String)this.metaProperties.get(name);
            globalAttributes.addAttribute(new MetadataAttribute(name, ProductData.createInstance((String)value), true));
        }
        return globalAttributes;
    }

    public void load(File propertiesFile, Logger logger) {
        if (propertiesFile == null) {
            return;
        }
        if (!propertiesFile.isFile()) {
            logger.warning(String.format("Metadata properties file '%s' not found", propertiesFile));
            return;
        }
        logger.info(String.format("Reading metadata properties file '%s'...", propertiesFile));
        try (FileReader reader = new FileReader(propertiesFile);){
            Properties properties = new Properties();
            properties.load(reader);
            for (String name : properties.stringPropertyNames()) {
                this.metaProperties.put(name, properties.getProperty(name));
            }
        }
        catch (IOException e) {
            String msgPattern = "Failed to load metadata properties file '%s': %s";
            logger.warning(String.format("Failed to load metadata properties file '%s': %s", propertiesFile, e.getMessage()));
        }
    }

    private static VelocityEngine createVelocityEngine(File absTemplateDir, Logger logger) {
        Properties veConfig = new Properties();
        if (absTemplateDir.equals(new File(".").getAbsoluteFile())) {
            veConfig.setProperty("file.resource.loader.path", absTemplateDir.getPath());
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.init(veConfig);
        }
        catch (Exception e) {
            String msgPattern = "Can't generate metadata file(s): Failed to initialise Velocity engine: %s";
            logger.log(Level.SEVERE, String.format("Can't generate metadata file(s): Failed to initialise Velocity engine: %s", e.getMessage()), e);
            return null;
        }
        return ve;
    }

    private static void processMetadataTemplate(File templateFile, VelocityEngine ve, VelocityContext vc, Logger logger) {
        String templateName = templateFile.getName();
        String outputName = templateName.substring(0, templateName.lastIndexOf(46));
        logger.info(String.format("Writing metadata file '%s'...", outputName));
        try (FileWriter writer = new FileWriter(outputName);){
            ve.mergeTemplate(templateName, "ISO-8859-1", (Context)vc, (Writer)writer);
        }
        catch (Exception e) {
            String msgPattern = "Failed to generate metadata file from template '%s': %s";
            logger.log(Level.SEVERE, String.format("Failed to generate metadata file from template '%s': %s", templateName, e.getMessage()), e);
        }
    }

    private GlobalMetadata(GlobalMetaParameter parameter) {
        this();
        Double periodDuration;
        OperatorDescriptor descriptor;
        File outputFile = parameter.getOutputFile();
        if (outputFile != null) {
            this.metaProperties.put("product_name", FileUtils.getFilenameWithoutExtension((File)outputFile));
        }
        if ((descriptor = parameter.getDescriptor()) != null) {
            this.metaProperties.put("software_qualified_name", descriptor.getName());
            this.metaProperties.put("software_name", descriptor.getAlias());
            this.metaProperties.put("software_version", descriptor.getVersion());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_OUTPUT_PATTERN, Locale.ENGLISH);
        this.metaProperties.put("processing_time", dateFormat.format(new Date()));
        String startDateTime = parameter.getStartDateTime();
        if (StringUtils.isNotNullAndNotEmpty((String)startDateTime)) {
            this.metaProperties.put("aggregation_period_start", startDateTime);
        }
        if ((periodDuration = parameter.getPeriodDuration()) != null) {
            this.metaProperties.put("aggregation_period_duration", Double.toString(periodDuration) + " day(s)");
        }
    }

    GlobalMetadata() {
    }

    private static class VelocityTemplateFilter
    implements FilenameFilter {
        private VelocityTemplateFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".vm");
        }
    }
}

