/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.Assert;
import org.esa.beam.binning.TypedConfig;
import org.esa.beam.binning.TypedDescriptor;
import org.esa.beam.binning.TypedDescriptorsRegistry;

public class TypedConfigDomConverter<TD extends TypedDescriptor, TC extends TypedConfig>
implements DomConverter {
    private final Class<TD> descriptorClass;
    private final Class<TC> configClass;

    protected TypedConfigDomConverter(Class<TD> descriptorClass, Class<TC> configClass) {
        this.descriptorClass = descriptorClass;
        this.configClass = configClass;
    }

    public Class<?> getValueType() {
        return this.configClass;
    }

    public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
        DomElement typeElement = (DomElement)parentElement.getChild("type");
        if (typeElement == null) {
            throw new ConversionException(String.format("Missing element 'type' in parent element '%s'", parentElement.getName()));
        }
        String typeName = typeElement.getValue();
        TypedConfig config = value == null ? this.createConfig(typeName) : (TypedConfig)((Object)value);
        DomConverter childConverter = this.createChildConverter(((Object)((Object)config)).getClass());
        childConverter.convertDomToValue(parentElement, (Object)config);
        return config;
    }

    public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
        DomConverter childConverter = this.createChildConverter(value.getClass());
        childConverter.convertValueToDom(value, parentElement);
    }

    protected TC createConfig(String typeName) {
        Assert.notNull((Object)typeName, (String)"typeName");
        TD descriptor = TypedDescriptorsRegistry.getInstance().getDescriptor(this.descriptorClass, typeName);
        Assert.argument((descriptor != null ? 1 : 0) != 0, (String)String.format("Unknown type name '%s'", typeName));
        return (TC)((Object)((TypedConfig)((Object)descriptor.createConfig())));
    }

    private DomConverter createChildConverter(Class<?> actualConfigType) {
        return new DefaultDomConverter(actualConfigType);
    }
}

