/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import org.esa.beam.binning.DataPeriod;
import org.esa.beam.binning.operator.BinningProductFilter;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.logging.BeamLogManager;

class SpatialDataDaySourceProductFilter
extends BinningProductFilter {
    private final DataPeriod dataPeriod;

    public SpatialDataDaySourceProductFilter(BinningProductFilter parent, DataPeriod dataPeriod) {
        this.setParent(parent);
        this.dataPeriod = dataPeriod;
    }

    @Override
    protected boolean acceptForBinning(Product product) {
        float firstLon = product.getGeoCoding().getGeoPos((PixelPos)new PixelPos((float)0.0f, (float)0.0f), null).lon;
        float lastLon = product.getGeoCoding().getGeoPos((PixelPos)new PixelPos((float)0.0f, (float)((float)(product.getSceneRasterHeight() - 1))), null).lon;
        ProductData.UTC firstScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)0.0);
        ProductData.UTC lastScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)(product.getSceneRasterHeight() - 1));
        DataPeriod.Membership firstLineMembership = this.dataPeriod.getObservationMembership(firstLon, firstScanLineTime.getMJD());
        DataPeriod.Membership lastLineMembership = this.dataPeriod.getObservationMembership(lastLon, lastScanLineTime.getMJD());
        String message = String.format("accepting product '%s': firstLineMembership=%s, lastLineMembership=%s, startTime=%s, endTime=%s", new Object[]{product.getName(), firstLineMembership, lastLineMembership, product.getStartTime(), product.getEndTime()});
        if (firstLineMembership == lastLineMembership && firstLineMembership != DataPeriod.Membership.CURRENT_PERIOD) {
            String msg = "not " + message;
            BeamLogManager.getSystemLogger().finer(msg);
            this.setReason(msg);
            return false;
        }
        BeamLogManager.getSystemLogger().finer(message);
        return true;
    }
}

