/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.esa.beam.binning.TemporalBin;
import org.esa.beam.binning.TemporalBinRenderer;
import org.esa.beam.binning.Vector;
import org.esa.beam.binning.operator.BinningOp;
import org.esa.beam.util.io.FileUtils;

public final class ImageTemporalBinRenderer
implements TemporalBinRenderer {
    private final int bandCount;
    private final int rasterWidth;
    private final int[] bandIndices;
    private final String[] bandNames;
    private final float[] bandMinValues;
    private final float[] bandMaxValues;
    private final float[][] bandData;
    private final Rectangle outputRegion;
    private final boolean writeRgb;
    private final File outputFile;
    private final String outputFormat;

    public ImageTemporalBinRenderer(String[] featureNames, File outputFile, String outputFormat, Rectangle outputRegion, BinningOp.BandConfiguration[] bandConfigurations, boolean writeRgb) {
        int i;
        int bandCount = bandConfigurations.length;
        if (bandCount == 0) {
            throw new IllegalArgumentException("No output band given.");
        }
        this.outputRegion = outputRegion;
        this.writeRgb = writeRgb;
        this.outputFile = outputFile;
        this.outputFormat = outputFormat;
        int rasterWidth = outputRegion.width;
        int rasterHeight = outputRegion.height;
        this.rasterWidth = rasterWidth;
        this.bandCount = bandCount;
        this.bandData = new float[bandCount][rasterWidth * rasterHeight];
        for (i = 0; i < this.bandCount; ++i) {
            Arrays.fill(this.bandData[i], Float.NaN);
        }
        this.bandIndices = new int[bandCount];
        this.bandNames = new String[bandCount];
        this.bandMinValues = new float[bandCount];
        this.bandMaxValues = new float[bandCount];
        for (i = 0; i < bandCount; ++i) {
            BinningOp.BandConfiguration bandConfiguration = bandConfigurations[i];
            String nameStr = bandConfiguration.name;
            this.bandIndices[i] = Integer.parseInt(bandConfiguration.index);
            this.bandNames[i] = nameStr != null ? nameStr : featureNames[this.bandIndices[i]];
            this.bandMinValues[i] = Float.parseFloat(bandConfiguration.minValue);
            this.bandMaxValues[i] = Float.parseFloat(bandConfiguration.maxValue);
        }
    }

    @Override
    public Rectangle getRasterRegion() {
        return this.outputRegion;
    }

    @Override
    public void begin() {
        File parentFile = this.outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
    }

    @Override
    public void end() throws IOException {
        if (this.writeRgb) {
            ImageTemporalBinRenderer.writeRgbImage(this.outputRegion.width, this.outputRegion.height, this.bandData, this.bandMinValues, this.bandMaxValues, this.outputFormat, this.outputFile);
        } else {
            for (int i = 0; i < this.bandCount; ++i) {
                String fileName = String.format("%s_%s%s", FileUtils.getFilenameWithoutExtension((File)this.outputFile), this.bandNames[i], FileUtils.getExtension((File)this.outputFile));
                File imageFile = new File(this.outputFile.getParentFile(), fileName);
                ImageTemporalBinRenderer.writeGrayScaleImage(this.outputRegion.width, this.outputRegion.height, this.bandData[i], this.bandMinValues[i], this.bandMaxValues[i], this.outputFormat, imageFile);
            }
        }
    }

    @Override
    public void renderBin(int x, int y, TemporalBin temporalBin, Vector outputVector) {
        for (int i = 0; i < this.bandCount; ++i) {
            this.bandData[i][this.rasterWidth * y + x] = outputVector.get(this.bandIndices[i]);
        }
    }

    @Override
    public void renderMissingBin(int x, int y) {
        for (int i = 0; i < this.bandCount; ++i) {
            this.bandData[i][this.rasterWidth * y + x] = Float.NaN;
        }
    }

    private static void writeGrayScaleImage(int width, int height, float[] rawData, float rawValue1, float rawValue2, String outputFormat, File outputImageFile) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 10);
        DataBufferByte dataBuffer = (DataBufferByte)image.getRaster().getDataBuffer();
        byte[] data = dataBuffer.getData();
        float a = 255.0f / (rawValue2 - rawValue1);
        float b = -255.0f * rawValue1 / (rawValue2 - rawValue1);
        for (int i = 0; i < rawData.length; ++i) {
            data[i] = ImageTemporalBinRenderer.toByte(rawData[i], a, b);
        }
        ImageIO.write((RenderedImage)image, outputFormat, outputImageFile);
    }

    private static void writeRgbImage(int width, int height, float[][] rawData, float[] rawValue1, float[] rawValue2, String outputFormat, File outputImageFile) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 5);
        DataBufferByte dataBuffer = (DataBufferByte)image.getRaster().getDataBuffer();
        byte[] data = dataBuffer.getData();
        float[] rawDataR = rawData[0];
        float[] rawDataG = rawData[1];
        float[] rawDataB = rawData[2];
        float aR = 255.0f / (rawValue2[0] - rawValue1[0]);
        float bR = -255.0f * rawValue1[0] / (rawValue2[0] - rawValue1[0]);
        float aG = 255.0f / (rawValue2[1] - rawValue1[1]);
        float bG = -255.0f * rawValue1[1] / (rawValue2[1] - rawValue1[1]);
        float aB = 255.0f / (rawValue2[2] - rawValue1[2]);
        float bB = -255.0f * rawValue1[2] / (rawValue2[2] - rawValue1[2]);
        int n = width * height;
        int i = 0;
        int j = 0;
        while (i < n) {
            data[j + 2] = ImageTemporalBinRenderer.toByte(rawDataR[i], aR, bR);
            data[j + 1] = ImageTemporalBinRenderer.toByte(rawDataG[i], aG, bG);
            data[j] = ImageTemporalBinRenderer.toByte(rawDataB[i], aB, bB);
            ++i;
            j += 3;
        }
        ImageIO.write((RenderedImage)image, outputFormat, outputImageFile);
    }

    private static byte toByte(float s, float a, float b) {
        int sample = (int)(a * s + b);
        if (sample < 0) {
            sample = 0;
        } else if (sample > 255) {
            sample = 255;
        }
        return (byte)sample;
    }
}

