/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.VirtualDir;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.SpatialBin;
import org.esa.beam.binning.operator.DeleteDirThread;
import org.esa.beam.binning.operator.SpatialBinCollection;
import org.esa.beam.binning.operator.SpatialBinCollector;
import org.esa.beam.util.io.FileUtils;

class FileBackedSpatialBinCollector
implements SpatialBinCollector {
    private static final int DEFAULT_NUM_BINS_PER_FILE = 100000;
    private static final int MAX_NUMBER_OF_CACHE_FILES = 10000;
    private static final String FILE_NAME_PATTERN = "bins-%05d.tmp";
    private final int numBinsPerFile;
    private final SortedMap<Long, List<SpatialBin>> map;
    private final AtomicBoolean consumingCompleted;
    private final File tempDir;
    private long currentFileIndex;
    private long numBinsComsumed;

    public FileBackedSpatialBinCollector(long maximumNumberOfBins) throws IOException {
        Assert.argument((maximumNumberOfBins > 0L ? 1 : 0) != 0, (String)"maximumNumberOfBins > 0");
        this.numBinsPerFile = FileBackedSpatialBinCollector.getNumBinsPerFile(maximumNumberOfBins);
        this.tempDir = VirtualDir.createUniqueTempDir();
        Runtime.getRuntime().addShutdownHook(new DeleteDirThread(this.tempDir));
        this.map = new TreeMap<Long, List<SpatialBin>>();
        this.consumingCompleted = new AtomicBoolean(false);
        this.currentFileIndex = 0L;
        this.numBinsComsumed = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeSpatialBins(BinningContext ignored, List<SpatialBin> spatialBins) throws Exception {
        if (this.consumingCompleted.get()) {
            throw new IllegalStateException("Consuming of bins has already been completed.");
        }
        SortedMap<Long, List<SpatialBin>> sortedMap = this.map;
        synchronized (sortedMap) {
            for (SpatialBin spatialBin : spatialBins) {
                ArrayList<SpatialBin> spatialBinList;
                ++this.numBinsComsumed;
                long spatialBinIndex = spatialBin.getIndex();
                int nextFileIndex = this.calculateNextFileIndex(spatialBinIndex);
                if ((long)nextFileIndex != this.currentFileIndex) {
                    this.writeMapToFile(this.currentFileIndex);
                    this.readFromFile(nextFileIndex);
                    this.currentFileIndex = nextFileIndex;
                }
                if ((spatialBinList = (ArrayList<SpatialBin>)this.map.get(spatialBinIndex)) == null) {
                    spatialBinList = new ArrayList<SpatialBin>();
                    this.map.put(spatialBinIndex, spatialBinList);
                }
                spatialBinList.add(spatialBin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumingCompleted() throws IOException {
        this.consumingCompleted.set(true);
        SortedMap<Long, List<SpatialBin>> sortedMap = this.map;
        synchronized (sortedMap) {
            this.writeMapToFile(this.currentFileIndex);
        }
    }

    @Override
    public SpatialBinCollection getSpatialBinCollection() throws IOException {
        return new FileBackedBinCollection(this.numBinsComsumed);
    }

    @Override
    public void close() {
        FileUtils.deleteTree((File)this.tempDir);
    }

    static void writeToStream(SortedMap<Long, List<SpatialBin>> map, DataOutputStream dos) throws IOException {
        for (Map.Entry<Long, List<SpatialBin>> entry : map.entrySet()) {
            dos.writeLong(entry.getKey());
            List<SpatialBin> binList = entry.getValue();
            dos.writeInt(binList.size());
            for (SpatialBin spatialBin : binList) {
                spatialBin.write(dos);
            }
        }
    }

    static void readFromStream(DataInputStream dis, SortedMap<Long, List<SpatialBin>> map) throws IOException {
        while (dis.available() != 0) {
            long binIndex = dis.readLong();
            int numBins = dis.readInt();
            ArrayList<SpatialBin> spatialBins = (ArrayList<SpatialBin>)map.get(binIndex);
            if (spatialBins == null) {
                spatialBins = new ArrayList<SpatialBin>(numBins);
            }
            for (int i = numBins; i > 0; --i) {
                spatialBins.add(SpatialBin.read(binIndex, dis));
            }
            map.put(binIndex, spatialBins);
        }
    }

    private static int getNumBinsPerFile(long maxBinCount) {
        int numCacheFiles = (int)Math.ceil((float)maxBinCount / 100000.0f);
        numCacheFiles = Math.min(numCacheFiles, 10000);
        int binsPerFile = (int)Math.ceil((float)maxBinCount / (float)numCacheFiles);
        return Math.max(100000, binsPerFile);
    }

    private void writeMapToFile(long fileIndex) throws IOException {
        if (!this.map.isEmpty()) {
            File file = this.getFile(fileIndex);
            this.writeToFile(this.map, file);
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(SortedMap<Long, List<SpatialBin>> map, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos, 0x500000));){
            FileBackedSpatialBinCollector.writeToStream(map, dos);
        }
    }

    private void readFromFile(long nextFileIndex) throws IOException {
        File file = this.getFile(nextFileIndex);
        if (file.exists()) {
            FileBackedSpatialBinCollector.readIntoMap(file, this.map);
        } else {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readIntoMap(File file, SortedMap<Long, List<SpatialBin>> map) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 0x500000));){
            FileBackedSpatialBinCollector.readFromStream(dis, map);
        }
    }

    private File getFile(long fileIndex) throws IOException {
        return new File(this.tempDir, String.format(FILE_NAME_PATTERN, fileIndex));
    }

    private int calculateNextFileIndex(long binIndex) {
        return (int)(binIndex / (long)this.numBinsPerFile);
    }

    private class FileBackedBinCollection
    implements SpatialBinCollection {
        private final long size;

        public FileBackedBinCollection(long size) {
            this.size = size;
        }

        @Override
        public Iterable<List<SpatialBin>> getBinCollection() {
            return new Iterable<List<SpatialBin>>(){

                @Override
                public Iterator<List<SpatialBin>> iterator() {
                    return new FileBackedBinIterator(FileBackedSpatialBinCollector.this.tempDir);
                }
            };
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        private class FileBackedBinIterator
        implements Iterator<List<SpatialBin>> {
            private final List<File> cacheFiles;
            private final List<List<SpatialBin>> currentList;

            private FileBackedBinIterator(File tempCacheDir) {
                this.cacheFiles = this.getCacheFiles(tempCacheDir);
                this.currentList = new LinkedList<List<SpatialBin>>();
            }

            @Override
            public boolean hasNext() {
                return !this.currentList.isEmpty() || !this.cacheFiles.isEmpty();
            }

            @Override
            public List<SpatialBin> next() {
                File currentFile;
                if (this.currentList.isEmpty() && (currentFile = this.cacheFiles.remove(0)).exists()) {
                    try {
                        this.readIntoList(currentFile, this.currentList);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    if (!currentFile.delete()) {
                        currentFile.deleteOnExit();
                    }
                }
                return this.currentList.remove(0);
            }

            private List<File> getCacheFiles(File cacheFileDir) {
                File[] files = cacheFileDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String fileName = file.getName();
                        return file.isFile() && fileName.startsWith("bins-") && fileName.endsWith(".tmp");
                    }
                });
                LinkedList<File> fileList = new LinkedList<File>();
                Collections.addAll(fileList, files);
                Collections.sort(fileList);
                return fileList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void readIntoList(File file, List<List<SpatialBin>> lists) throws IOException {
                FileInputStream fis = new FileInputStream(file);
                try (DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 0x500000));){
                    this.readIntoList(dis, lists);
                }
            }

            private void readIntoList(DataInputStream dis, List<List<SpatialBin>> list) throws IOException {
                while (dis.available() != 0) {
                    long binIndex = dis.readLong();
                    int numBins = dis.readInt();
                    ArrayList<SpatialBin> spatialBins = new ArrayList<SpatialBin>(numBins);
                    for (int i = numBins; i > 0; --i) {
                        spatialBins.add(SpatialBin.read(binIndex, dis));
                    }
                    list.add(spatialBins);
                }
            }

            @Override
            public void remove() {
            }
        }
    }
}

