/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import com.bc.ceres.binding.BindingException;
import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Constructor;
import org.esa.beam.binning.Aggregator;
import org.esa.beam.binning.AggregatorConfig;
import org.esa.beam.binning.AggregatorDescriptor;
import org.esa.beam.binning.BinManager;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.CellProcessorConfig;
import org.esa.beam.binning.CompositingType;
import org.esa.beam.binning.DataPeriod;
import org.esa.beam.binning.PlanetaryGrid;
import org.esa.beam.binning.TemporalDataPeriod;
import org.esa.beam.binning.TypedDescriptorsRegistry;
import org.esa.beam.binning.VariableContext;
import org.esa.beam.binning.operator.AggregatorConfigDomConverter;
import org.esa.beam.binning.operator.CellProcessorConfigDomConverter;
import org.esa.beam.binning.operator.VariableConfig;
import org.esa.beam.binning.support.BinningContextImpl;
import org.esa.beam.binning.support.SEAGrid;
import org.esa.beam.binning.support.SpatialDataPeriod;
import org.esa.beam.binning.support.VariableContextImpl;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.ParameterBlockConverter;

public class BinningConfig {
    private String planetaryGrid = "org.esa.beam.binning.support.SEAGrid";
    @Parameter
    private int numRows;
    private CompositingType compositingType = CompositingType.BINNING;
    @Parameter
    private Integer superSampling;
    @Parameter
    private String maskExpr;
    @Parameter(alias="variables", itemAlias="variable")
    private VariableConfig[] variableConfigs;
    @Parameter(alias="aggregators", domConverter=AggregatorConfigDomConverter.class)
    private AggregatorConfig[] aggregatorConfigs;
    @Parameter(alias="postProcessor", domConverter=CellProcessorConfigDomConverter.class)
    private CellProcessorConfig postProcessorConfig;
    @Parameter(description="The time in hours of a day (0 to 24) at which a given sensor has a minimum number of observations at the date line (the 180 degree meridian). Only used if parameter 'startDate' is set.")
    private Double minDataHour;

    public String getPlanetaryGrid() {
        return this.planetaryGrid;
    }

    public void setPlanetaryGrid(String planetaryGrid) {
        this.planetaryGrid = planetaryGrid;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public Double getMinDataHour() {
        return this.minDataHour;
    }

    public void setMinDataHour(Double minDataHour) {
        this.minDataHour = minDataHour;
    }

    public String getMaskExpr() {
        return this.maskExpr;
    }

    public void setMaskExpr(String maskExpr) {
        this.maskExpr = maskExpr;
    }

    public Integer getSuperSampling() {
        return this.superSampling;
    }

    public void setSuperSampling(Integer superSampling) {
        this.superSampling = superSampling;
    }

    public CompositingType getCompositingType() {
        return this.compositingType;
    }

    public void setCompositingType(CompositingType type) {
        this.compositingType = type;
    }

    public VariableConfig[] getVariableConfigs() {
        return this.variableConfigs;
    }

    public void setVariableConfigs(VariableConfig ... variableConfigs) {
        this.variableConfigs = variableConfigs;
    }

    public AggregatorConfig[] getAggregatorConfigs() {
        return this.aggregatorConfigs;
    }

    public void setAggregatorConfigs(AggregatorConfig ... aggregatorConfigs) {
        this.aggregatorConfigs = aggregatorConfigs;
    }

    public CellProcessorConfig getPostProcessorConfig() {
        return this.postProcessorConfig;
    }

    public void setPostProcessorConfig(CellProcessorConfig cellProcessorConfig) {
        this.postProcessorConfig = cellProcessorConfig;
    }

    public static BinningConfig fromXml(String xml) throws BindingException {
        return (BinningConfig)new ParameterBlockConverter().convertXmlToObject(xml, (Object)new BinningConfig());
    }

    public String toXml() {
        try {
            return new ParameterBlockConverter().convertObjectToXml((Object)this);
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public BinningContext createBinningContext(Geometry region, ProductData.UTC startDate, Double periodDuration) {
        VariableContext variableContext = this.createVariableContext();
        return new BinningContextImpl(this.createPlanetaryGrid(), this.createBinManager(variableContext), this.compositingType, this.getSuperSampling() != null ? this.getSuperSampling() : 1, BinningConfig.createDataPeriod(startDate, periodDuration, this.minDataHour), region);
    }

    public PlanetaryGrid createPlanetaryGrid() {
        if (this.planetaryGrid == null) {
            if (this.numRows > 0) {
                return new SEAGrid(this.numRows);
            }
            return new SEAGrid();
        }
        try {
            if (this.numRows > 0) {
                Constructor<?> constructor = Class.forName(this.planetaryGrid).getConstructor(Integer.TYPE);
                return (PlanetaryGrid)constructor.newInstance(this.numRows);
            }
            return (PlanetaryGrid)Class.forName(this.planetaryGrid).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.planetaryGrid, e);
        }
    }

    private BinManager createBinManager(VariableContext variableContext) {
        Aggregator[] aggregators = this.createAggregators(variableContext);
        return this.createBinManager(variableContext, aggregators);
    }

    public Aggregator[] createAggregators(VariableContext variableContext) {
        if (this.aggregatorConfigs == null) {
            return new Aggregator[0];
        }
        Aggregator[] aggregators = new Aggregator[this.aggregatorConfigs.length];
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        for (int i = 0; i < aggregators.length; ++i) {
            AggregatorConfig aggregatorConfig = this.aggregatorConfigs[i];
            AggregatorDescriptor descriptor = registry.getDescriptor(AggregatorDescriptor.class, aggregatorConfig.getName());
            if (descriptor == null) {
                throw new IllegalArgumentException("Unknown aggregator type: " + aggregatorConfig.getName());
            }
            aggregators[i] = descriptor.createAggregator(variableContext, aggregatorConfig);
        }
        return aggregators;
    }

    protected BinManager createBinManager(VariableContext variableContext, Aggregator[] aggregators) {
        return new BinManager(variableContext, this.postProcessorConfig, aggregators);
    }

    public VariableContext createVariableContext() {
        VariableContextImpl variableContext = new VariableContextImpl();
        variableContext.setMaskExpr(this.maskExpr);
        if (this.variableConfigs != null) {
            for (VariableConfig variableConfig : this.variableConfigs) {
                variableContext.defineVariable(variableConfig.getName(), variableConfig.getExpr());
            }
        }
        if (this.aggregatorConfigs != null) {
            TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
            for (AggregatorConfig aggregatorConfig : this.aggregatorConfigs) {
                AggregatorDescriptor descriptor = registry.getDescriptor(AggregatorDescriptor.class, aggregatorConfig.getName());
                if (descriptor != null) {
                    String[] varNames;
                    for (String varName : varNames = descriptor.getSourceVarNames(aggregatorConfig)) {
                        variableContext.defineVariable(varName);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown aggregator type: " + aggregatorConfig.getName());
            }
        }
        return variableContext;
    }

    public static DataPeriod createDataPeriod(ProductData.UTC startUtc, Double periodDuration, Double minDataHour) {
        if (startUtc != null) {
            if (minDataHour != null) {
                return new SpatialDataPeriod(startUtc.getMJD(), periodDuration, minDataHour);
            }
            return new TemporalDataPeriod(startUtc.getMJD(), periodDuration);
        }
        return null;
    }
}

