/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.cellprocessor;

import org.esa.beam.binning.BinManager;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.TemporalBin;
import org.esa.beam.binning.WritableVector;

public class CellProcessorChain {
    private final BinManager binManager;

    public CellProcessorChain(BinningContext binningContext) {
        this.binManager = binningContext.getBinManager();
    }

    public TemporalBin process(TemporalBin temporalBin) {
        if (this.binManager.hasPostProcessor()) {
            WritableVector temporalVector = temporalBin.toVector();
            TemporalBin processBin = this.binManager.createProcessBin(temporalBin.getIndex());
            this.binManager.postProcess(temporalVector, processBin.toVector());
            processBin.setNumObs(temporalBin.getNumObs());
            processBin.setNumPasses(temporalBin.getNumPasses());
            return processBin;
        }
        return temporalBin;
    }
}

