/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.aggregators;

import java.util.Arrays;
import org.esa.beam.binning.AbstractAggregator;
import org.esa.beam.binning.Aggregator;
import org.esa.beam.binning.AggregatorConfig;
import org.esa.beam.binning.AggregatorDescriptor;
import org.esa.beam.binning.BinContext;
import org.esa.beam.binning.Observation;
import org.esa.beam.binning.VariableContext;
import org.esa.beam.binning.Vector;
import org.esa.beam.binning.WeightFn;
import org.esa.beam.binning.WritableVector;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.util.StringUtils;

public final class AggregatorAverage
extends AbstractAggregator {
    private final int varIndex;
    private final WeightFn weightFn;
    private final boolean outputCounts;
    private final String icName;
    private final boolean outputSums;

    public AggregatorAverage(VariableContext varCtx, String varName, double weightCoeff) {
        this(varCtx, varName, varName, weightCoeff, false, false);
    }

    public AggregatorAverage(VariableContext varCtx, String varName, String targetName, double weightCoeff, boolean outputCounts, boolean outputSums) {
        super("AVG", AggregatorAverage.createFeatureNames(varName, "sum", "sum_sq", outputCounts ? "counts" : null), AggregatorAverage.createFeatureNames(varName, "sum", "sum_sq", "weights", outputCounts ? "counts" : null), outputSums ? AggregatorAverage.createFeatureNames(targetName, "sum", "sum_sq", "weights", outputCounts ? "counts" : null) : AggregatorAverage.createFeatureNames(targetName, "mean", "sigma", outputCounts ? "counts" : null));
        if (varCtx == null) {
            throw new NullPointerException("varCtx");
        }
        if (varName == null) {
            throw new NullPointerException("varName");
        }
        if (weightCoeff < 0.0) {
            throw new IllegalArgumentException("weightCoeff < 0.0");
        }
        this.varIndex = varCtx.getVariableIndex(varName);
        this.weightFn = WeightFn.createPow(weightCoeff);
        this.outputCounts = outputCounts;
        this.outputSums = outputSums;
        this.icName = "ic." + varName;
    }

    @Override
    public void initSpatial(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
        if (this.outputCounts) {
            vector.set(2, 0.0f);
        } else {
            this.initNumInvalids(ctx);
        }
    }

    @Override
    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
        vector.set(2, 0.0f);
        if (this.outputCounts) {
            vector.set(3, 0.0f);
        } else {
            this.initNumInvalids(ctx);
        }
    }

    @Override
    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        float value = observationVector.get(this.varIndex);
        if (!Float.isNaN(value)) {
            spatialVector.set(0, spatialVector.get(0) + value);
            spatialVector.set(1, spatialVector.get(1) + value * value);
            if (this.outputCounts) {
                spatialVector.set(2, spatialVector.get(2) + 1.0f);
            }
        } else if (!this.outputCounts) {
            this.incrementNumInvalids(ctx);
        }
    }

    @Override
    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        int counts = this.outputCounts ? (int)spatialVector.get(2) : numSpatialObs - this.getNumInvalids(ctx);
        if (counts > 0) {
            spatialVector.set(0, spatialVector.get(0) / (float)counts);
            spatialVector.set(1, spatialVector.get(1) / (float)counts);
        } else {
            spatialVector.set(0, Float.NaN);
            spatialVector.set(1, Float.NaN);
        }
    }

    @Override
    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        float w = this.weightFn.eval(numSpatialObs);
        float sum = spatialVector.get(0);
        float sumSqr = spatialVector.get(1);
        if (!Float.isNaN(sum)) {
            temporalVector.set(0, temporalVector.get(0) + sum * w);
            temporalVector.set(1, temporalVector.get(1) + sumSqr * w);
            temporalVector.set(2, temporalVector.get(2) + w);
            if (this.outputCounts) {
                float counts = spatialVector.get(2);
                temporalVector.set(3, temporalVector.get(3) + counts);
            }
        }
    }

    @Override
    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    @Override
    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        double sumX = temporalVector.get(0);
        double sumXX = temporalVector.get(1);
        double sumW = temporalVector.get(2);
        int index = 0;
        if (this.outputSums) {
            outputVector.set(index++, (float)sumX);
            outputVector.set(index++, (float)sumXX);
            outputVector.set(index++, (float)sumW);
        } else if (sumW > 0.0) {
            double mean = sumX / sumW;
            double sigmaSqr = sumXX / sumW - mean * mean;
            double sigma = sigmaSqr > 0.0 ? Math.sqrt(sigmaSqr) : 0.0;
            outputVector.set(index++, (float)mean);
            outputVector.set(index++, (float)sigma);
        } else {
            outputVector.set(index++, Float.NaN);
            outputVector.set(index++, Float.NaN);
        }
        if (this.outputCounts) {
            if (sumW > 0.0) {
                float counts = temporalVector.get(3);
                outputVector.set(index, counts);
            } else {
                outputVector.set(index, 0.0f);
            }
        }
    }

    private void initNumInvalids(BinContext ctx) {
        ctx.put(this.icName, new int[1]);
    }

    private void incrementNumInvalids(BinContext ctx) {
        int[] nArray = (int[])ctx.get(this.icName);
        nArray[0] = nArray[0] + 1;
    }

    private int getNumInvalids(BinContext ctx) {
        return ((int[])ctx.get(this.icName))[0];
    }

    public String toString() {
        return "AggregatorAverage{, varIndex=" + this.varIndex + ", weightFn=" + this.weightFn + ", spatialFeatureNames=" + Arrays.toString(this.getSpatialFeatureNames()) + ", temporalFeatureNames=" + Arrays.toString(this.getTemporalFeatureNames()) + ", outputFeatureNames=" + Arrays.toString(this.getOutputFeatureNames()) + '}';
    }

    public static class Descriptor
    implements AggregatorDescriptor {
        public static final String NAME = "AVG";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            double weightCoeff = config.weightCoeff != null ? config.weightCoeff : 0.0;
            boolean outputCounts = config.outputCounts != null ? config.outputCounts : false;
            boolean outputSums = config.outputSums != null ? config.outputSums : false;
            return new AggregatorAverage(varCtx, config.varName, targetName, weightCoeff, outputCounts, outputSums);
        }

        @Override
        public AggregatorConfig createConfig() {
            return new Config();
        }

        @Override
        public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            return new String[]{config.varName};
        }

        @Override
        public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
            boolean outputSums;
            Config config = (Config)aggregatorConfig;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            boolean outputCounts = config.outputCounts != null ? config.outputCounts : false;
            boolean bl = outputSums = config.outputSums != null ? config.outputSums : false;
            return outputSums ? AbstractAggregator.createFeatureNames(targetName, "sum", "sum_sq", "weights", outputCounts ? "counts" : null) : AbstractAggregator.createFeatureNames(targetName, "mean", "sigma", outputCounts ? "counts" : null);
        }
    }

    public static class Config
    extends AggregatorConfig {
        @Parameter(label="Source band name", notEmpty=true, notNull=true, description="The source band used for aggregation.")
        String varName;
        @Parameter(label="Target band name prefix (optional)", description="The name prefix for the resulting bands. If empty, the source band name is used.")
        String targetName;
        @Parameter(label="Weight coefficient", defaultValue="0.0", description="The number of spatial observations to the power of this value \nwill define the value for weighting the sums. Zero means observation count weighting is disabled.")
        Double weightCoeff;
        @Parameter(defaultValue="false", description="If true, the result will include the count of all valid values.")
        Boolean outputCounts;
        @Parameter(defaultValue="false", description="If true, the result will include the sum of all values.")
        Boolean outputSums;

        public Config() {
            this(null, null, null, null, null);
        }

        public Config(String varName) {
            this(varName, null, null, null, null);
        }

        public Config(String varName, String targetName, Double weightCoeff, Boolean outputCounts, Boolean outputSums) {
            super("AVG");
            this.varName = varName;
            this.targetName = targetName;
            this.weightCoeff = weightCoeff;
            this.outputCounts = outputCounts;
            this.outputSums = outputSums;
        }
    }
}

