/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning;

import java.io.IOException;
import org.esa.beam.binning.BinManager;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.SpatialBin;
import org.esa.beam.binning.TemporalBin;

public class TemporalBinner {
    private final BinManager binManager;

    public TemporalBinner(BinningContext binningContext) {
        this.binManager = binningContext.getBinManager();
    }

    public TemporalBin processSpatialBins(long binIndex, Iterable<? extends SpatialBin> spatialBins) throws IOException {
        return this.binManager.createTemporalBin(binIndex, spatialBins);
    }

    public TemporalBin computeOutput(long binIndex, TemporalBin temporalBin) {
        TemporalBin outputBin = this.binManager.createOutputBin(binIndex);
        this.binManager.computeOutput(temporalBin, outputBin.toVector());
        outputBin.setNumObs(temporalBin.getNumObs());
        outputBin.setNumPasses(temporalBin.getNumPasses());
        return outputBin;
    }
}

