/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.esa.beam.binning.BinManager;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.Observation;
import org.esa.beam.binning.PlanetaryGrid;
import org.esa.beam.binning.SpatialBin;
import org.esa.beam.binning.SpatialBinConsumer;

public class SpatialBinner {
    private final BinningContext binningContext;
    private final PlanetaryGrid planetaryGrid;
    private final BinManager binManager;
    private final SpatialBinConsumer consumer;
    private final Map<Long, SpatialBin> activeBinMap;
    private final Map<Long, SpatialBin> finalizedBinMap;
    private final ArrayList<Exception> exceptions;

    public SpatialBinner(BinningContext binningContext, SpatialBinConsumer consumer) {
        this.binningContext = binningContext;
        this.planetaryGrid = binningContext.getPlanetaryGrid();
        this.binManager = binningContext.getBinManager();
        this.consumer = consumer;
        this.activeBinMap = new TreeMap<Long, SpatialBin>();
        this.finalizedBinMap = new TreeMap<Long, SpatialBin>();
        this.exceptions = new ArrayList();
    }

    public BinningContext getBinningContext() {
        return this.binningContext;
    }

    public Exception[] getExceptions() {
        return this.exceptions.toArray(new Exception[this.exceptions.size()]);
    }

    public long processObservationSlice(Iterable<Observation> observations) {
        this.finalizedBinMap.putAll(this.activeBinMap);
        long observationCounter = 0L;
        for (Observation observation : observations) {
            ++observationCounter;
            Long binIndex = this.planetaryGrid.getBinIndex(observation.getLatitude(), observation.getLongitude());
            SpatialBin bin = this.activeBinMap.get(binIndex);
            if (bin == null) {
                bin = this.binManager.createSpatialBin(binIndex);
                this.activeBinMap.put(binIndex, bin);
            }
            this.binManager.aggregateSpatialBin(observation, bin);
            this.finalizedBinMap.remove(binIndex);
        }
        if (!this.finalizedBinMap.isEmpty()) {
            for (Long key : this.finalizedBinMap.keySet()) {
                this.activeBinMap.remove(key);
            }
            this.emitSliceBins(this.finalizedBinMap);
            this.finalizedBinMap.clear();
        }
        return observationCounter;
    }

    public long processObservationSlice(Observation ... observations) {
        return this.processObservationSlice(Arrays.asList(observations));
    }

    public void complete() {
        if (!this.activeBinMap.isEmpty()) {
            this.emitSliceBins(this.activeBinMap);
            this.activeBinMap.clear();
        }
        this.finalizedBinMap.clear();
    }

    private void emitSliceBins(Map<Long, SpatialBin> binMap) {
        ArrayList<SpatialBin> bins = new ArrayList<SpatialBin>(binMap.values());
        for (SpatialBin bin : bins) {
            this.binManager.completeSpatialBin(bin);
        }
        try {
            this.consumer.consumeSpatialBins(this.getBinningContext(), bins);
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
    }
}

