/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.Grid;
import com.bc.ceres.swing.ListControlBar;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.binning.operator.ui.AggregatorItem;
import org.esa.snap.binning.operator.ui.AggregatorItemDialog;
import org.esa.snap.binning.operator.ui.BinningFormModel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

class AggregatorTableController
extends ListControlBar.AbstractListController {
    private final Grid grid;
    private final BinningFormModel binningFormModel;
    private final List<AggregatorItem> aggregatorItems;

    AggregatorTableController(Grid grid, BinningFormModel binningFormModel) {
        this.grid = grid;
        this.binningFormModel = binningFormModel;
        this.aggregatorItems = new ArrayList<AggregatorItem>();
        this.addAggregatorConfigs(this.binningFormModel.getAggregatorConfigs());
    }

    public boolean addRow(int index) {
        boolean ok = this.editAggregatorItem(new AggregatorItem(), -1);
        if (ok) {
            this.updateBinningFormModel();
        }
        return ok;
    }

    public boolean removeRows(int[] indices) {
        this.grid.removeDataRows(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.aggregatorItems.remove(indices[i]);
        }
        this.updateBinningFormModel();
        return true;
    }

    public boolean moveRowUp(int index) {
        this.grid.moveDataRowUp(index);
        AggregatorItem ac1 = this.aggregatorItems.get(index - 1);
        AggregatorItem ac2 = this.aggregatorItems.get(index);
        this.aggregatorItems.set(index - 1, ac2);
        this.aggregatorItems.set(index, ac1);
        this.updateBinningFormModel();
        return true;
    }

    public boolean moveRowDown(int index) {
        this.grid.moveDataRowDown(index);
        AggregatorItem ac1 = this.aggregatorItems.get(index);
        AggregatorItem ac2 = this.aggregatorItems.get(index + 1);
        this.aggregatorItems.set(index, ac2);
        this.aggregatorItems.set(index + 1, ac1);
        this.updateBinningFormModel();
        return true;
    }

    void setAggregatorConfigs(AggregatorConfig[] configs) {
        this.clearGrid();
        this.addAggregatorConfigs(configs);
        this.updateBinningFormModel();
    }

    static boolean isSourcePropertyName(String propertyName) {
        return propertyName.toLowerCase().contains("varname");
    }

    private void clearGrid() {
        int[] rowIndices = new int[this.grid.getDataRowCount()];
        for (int i = 0; i < rowIndices.length; ++i) {
            rowIndices[i] = i;
        }
        this.removeRows(rowIndices);
    }

    private void addAggregatorConfigs(AggregatorConfig[] aggregatorConfigs) {
        for (AggregatorConfig aggregatorConfig : aggregatorConfigs) {
            this.addDataRow(new AggregatorItem(aggregatorConfig));
        }
    }

    private void updateBinningFormModel() {
        AggregatorConfig[] aggregatorConfigs = new AggregatorConfig[this.aggregatorItems.size()];
        for (int i = 0; i < this.aggregatorItems.size(); ++i) {
            AggregatorItem aggregatorItem = this.aggregatorItems.get(i);
            aggregatorConfigs[i] = aggregatorItem.aggregatorConfig;
        }
        try {
            this.binningFormModel.setProperty("aggregatorConfigs", aggregatorConfigs);
        }
        catch (ValidationException e) {
            Dialogs.showError((String)"Aggregator Configuration", (String)e.getMessage());
        }
    }

    private boolean editAggregatorItem(AggregatorItem aggregatorItem, int rowIndex) {
        Product contextProduct = this.binningFormModel.getContextProduct();
        if (contextProduct == null) {
            Dialogs.showInformation((String)"Please select source products before adding aggregators.");
            return false;
        }
        String[] varNames = this.getVariableNames(this.binningFormModel.getVariableConfigs());
        String[] bandNames = contextProduct.getBandNames();
        String[] tiePointGridNames = contextProduct.getTiePointGridNames();
        String[] maskNames = contextProduct.getMaskGroup().getNodeNames();
        String[] sourceNames = StringUtils.addArrays((String[])varNames, (String[])bandNames);
        sourceNames = StringUtils.addArrays((String[])sourceNames, (String[])tiePointGridNames);
        sourceNames = StringUtils.addArrays((String[])sourceNames, (String[])maskNames);
        boolean isNewAggregatorItem = rowIndex < 0;
        AggregatorItemDialog aggregatorDialog = new AggregatorItemDialog(SwingUtilities.getWindowAncestor((Component)this.grid), sourceNames, aggregatorItem, isNewAggregatorItem);
        int result = aggregatorDialog.show();
        if (result == 1) {
            if (isNewAggregatorItem) {
                this.addDataRow(aggregatorItem);
            } else {
                this.updateDataRow(aggregatorItem, rowIndex);
            }
            return true;
        }
        return false;
    }

    private String[] getVariableNames(VariableConfig[] variableConfigs) {
        String[] varNames = new String[variableConfigs.length];
        for (int i = 0; i < variableConfigs.length; ++i) {
            varNames[i] = variableConfigs[i].getName();
        }
        return varNames;
    }

    private void addDataRow(AggregatorItem ac) {
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        JLabel typeLabel = new JLabel(this.getTypeText(ac));
        typeLabel.setBorder(emptyBorder);
        JLabel sourceBandsLabel = new JLabel(this.getSourceBandsText(ac));
        sourceBandsLabel.setBorder(emptyBorder);
        JLabel parametersLabel = new JLabel(this.getParametersText(ac));
        parametersLabel.setBorder(emptyBorder);
        JLabel targetBandsLabel = new JLabel(this.getTargetBandsText(ac));
        targetBandsLabel.setBorder(emptyBorder);
        final AbstractButton editButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/Edit16.gif"), (boolean)false);
        editButton.setRolloverEnabled(true);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = AggregatorTableController.this.grid.findDataRowIndex((JComponent)editButton);
                AggregatorTableController.this.editAggregatorItem((AggregatorItem)AggregatorTableController.this.aggregatorItems.get(rowIndex), rowIndex);
            }
        });
        this.grid.addDataRow(new JComponent[]{typeLabel, sourceBandsLabel, parametersLabel, targetBandsLabel, editButton});
        this.aggregatorItems.add(ac);
    }

    private void updateDataRow(AggregatorItem ac, int rowIndex) {
        JComponent[] components = this.grid.getDataRow(rowIndex);
        ((JLabel)components[0]).setText(this.getTypeText(ac));
        ((JLabel)components[1]).setText(this.getSourceBandsText(ac));
        ((JLabel)components[2]).setText(this.getParametersText(ac));
        ((JLabel)components[3]).setText(this.getTargetBandsText(ac));
        this.updateBinningFormModel();
    }

    private String getTypeText(AggregatorItem ac) {
        return "<html><b>" + ac.aggregatorConfig.getName() + "</b>";
    }

    private String getSourceBandsText(AggregatorItem ac) {
        Object[] sourceVarNames = ac.aggregatorDescriptor.getSourceVarNames(ac.aggregatorConfig);
        return sourceVarNames.length != 0 ? "<html>" + StringUtils.join((Object[])sourceVarNames, (String)"<br/>") : "";
    }

    private String getTargetBandsText(AggregatorItem ac) {
        Object[] targetVarNames = ac.aggregatorDescriptor.getTargetVarNames(ac.aggregatorConfig);
        return targetVarNames.length != 0 ? "<html>" + StringUtils.join((Object[])targetVarNames, (String)"<br/>") : "";
    }

    private String getParametersText(AggregatorItem ac) {
        PropertySet container = ac.aggregatorConfig.asPropertySet();
        StringBuilder sb = new StringBuilder();
        for (Property property : container.getProperties()) {
            String propertyName = property.getName();
            if (AggregatorTableController.isSourcePropertyName(propertyName) || propertyName.equals("type")) continue;
            if (sb.length() > 0) {
                sb.append("<br/>");
            }
            sb.append(String.format("%s = %s", propertyName, property.getValueAsText()));
        }
        return "<html>" + sb.toString();
    }
}

