/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.esa.snap.binning.operator.ui.VariableItem;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductExpressionPane;

class VariableItemDialog
extends ModalDialog {
    private static final String PROPERTY_VARIABLE_NAME = "name";
    private static final String PROPERTY_EXPRESSION = "expr";
    private final VariableItem variableItem;
    private final boolean newVariable;
    private final Product contextProduct;
    private final BindingContext bindingContext;

    VariableItemDialog(Window parent, VariableItem variableItem, boolean createNewVariable, Product contextProduct) {
        super(parent, "Intermediate Source Band", 33, null);
        this.variableItem = variableItem;
        this.newVariable = createNewVariable;
        this.contextProduct = contextProduct;
        this.bindingContext = this.createBindingContext();
        this.makeUI();
    }

    protected boolean verifyUserInput() {
        String variableName;
        String expression;
        String string = expression = this.variableItem.variableConfig.getExpr() != null ? this.variableItem.variableConfig.getExpr().trim() : "";
        if (StringUtils.isNullOrEmpty((String)expression)) {
            JOptionPane.showMessageDialog(this.getParent(), "The source band could not be created. The expression is empty.");
            return false;
        }
        String string2 = variableName = this.variableItem.variableConfig.getName() != null ? this.variableItem.variableConfig.getName().trim() : "";
        if (StringUtils.isNullOrEmpty((String)variableName)) {
            JOptionPane.showMessageDialog(this.getParent(), "The source band could not be created. The name is empty.");
            return false;
        }
        if (this.newVariable && this.contextProduct.containsBand(variableName)) {
            String message = String.format("A source band or band with the name '%s' is already defined", variableName);
            JOptionPane.showMessageDialog(this.getParent(), message);
            return false;
        }
        try {
            BandArithmetic.getValidMaskExpression((String)expression, (Product)this.contextProduct, null);
        }
        catch (ParseException e) {
            String errorMessage = "The source band could not be created.\nThe expression could not be parsed:\n" + e.getMessage();
            JOptionPane.showMessageDialog(this.getParent(), errorMessage);
            return false;
        }
        return true;
    }

    protected void onOK() {
        this.variableItem.variableConfig.setName(this.variableItem.variableConfig.getName().trim());
        this.variableItem.variableConfig.setExpr(this.variableItem.variableConfig.getExpr().trim());
        super.onOK();
    }

    VariableItem getVariableItem() {
        return this.variableItem;
    }

    private BindingContext createBindingContext() {
        PropertyContainer container = PropertyContainer.createObjectBacked((Object)this.variableItem.variableConfig, (PropertyDescriptorFactory)new ParameterDescriptorFactory());
        BindingContext context = new BindingContext((PropertySet)container);
        PropertyDescriptor descriptor = container.getDescriptor(PROPERTY_VARIABLE_NAME);
        descriptor.setDescription("The name for the source band.");
        descriptor.setValidator((Validator)new VariableNameValidator());
        container.setDefaultValues();
        return context;
    }

    private void makeUI() {
        JComponent[] variableComponents = this.createComponents(PROPERTY_VARIABLE_NAME, TextFieldEditor.class);
        TableLayout layout = new TableLayout(2);
        layout.setTablePadding(4, 3);
        layout.setCellWeightX(0, 1, Double.valueOf(1.0));
        layout.setCellWeightX(1, 1, Double.valueOf(1.0));
        layout.setCellWeightX(2, 0, Double.valueOf(1.0));
        layout.setCellColspan(2, 0, Integer.valueOf(2));
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add(variableComponents[1]);
        panel.add(variableComponents[0]);
        JLabel expressionLabel = new JLabel("Variable expression:");
        JTextArea expressionArea = new JTextArea();
        expressionArea.setRows(3);
        TextComponentAdapter textComponentAdapter = new TextComponentAdapter((JTextComponent)expressionArea);
        this.bindingContext.bind(PROPERTY_EXPRESSION, (ComponentAdapter)textComponentAdapter);
        panel.add(expressionLabel);
        panel.add(layout.createHorizontalSpacer());
        panel.add(expressionArea);
        JButton editExpressionButton = new JButton("Edit Expression...");
        editExpressionButton.setName("editExpressionButton");
        editExpressionButton.addActionListener(this.createEditExpressionButtonListener());
        panel.add(layout.createHorizontalSpacer());
        panel.add(editExpressionButton);
        this.setContent(panel);
    }

    private JComponent[] createComponents(String propertyName, Class<? extends PropertyEditor> editorClass) {
        PropertyDescriptor descriptor = this.bindingContext.getPropertySet().getDescriptor(propertyName);
        PropertyEditor editor = PropertyEditorRegistry.getInstance().getPropertyEditor(editorClass.getName());
        return editor.createComponents(descriptor, this.bindingContext);
    }

    private ActionListener createEditExpressionButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductExpressionPane expressionPane = ProductExpressionPane.createGeneralExpressionPane((Product[])new Product[]{VariableItemDialog.this.contextProduct}, (Product)VariableItemDialog.this.contextProduct, null);
                expressionPane.setCode(((VariableItemDialog)VariableItemDialog.this).variableItem.variableConfig.getExpr());
                int status = expressionPane.showModalDialog((Window)VariableItemDialog.this.getJDialog(), "Expression Editor");
                if (status == 1) {
                    VariableItemDialog.this.bindingContext.getBinding(VariableItemDialog.PROPERTY_EXPRESSION).setPropertyValue((Object)expressionPane.getCode());
                }
                expressionPane.dispose();
            }
        };
    }

    private class VariableNameValidator
    implements Validator {
        private VariableNameValidator() {
        }

        public void validateValue(Property property, Object value) throws ValidationException {
            String name = (String)value;
            if (VariableItemDialog.this.contextProduct.containsRasterDataNode(name)) {
                throw new ValidationException("The source band name must be unique.");
            }
        }
    }
}

