/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.VarElementCountSequenceType;
import java.io.IOException;

public final class VarElementCountSequenceTypeImpl
extends VarElementCountSequenceType {
    private final String memberName;
    private volatile int memberIndex;

    public VarElementCountSequenceTypeImpl(Type elementType, int memberIndex) {
        super(elementType.getName() + "[$" + memberIndex + "]", elementType);
        this.memberName = null;
        this.memberIndex = memberIndex;
    }

    public VarElementCountSequenceTypeImpl(Type elementType, String memberName) {
        super(elementType.getName() + "[$" + memberName + "]", elementType);
        this.memberName = memberName;
        this.memberIndex = -1;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public int getMemberIndex() {
        return this.memberIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int resolveElementCount(CollectionData parent) throws IOException {
        if (this.memberIndex == -1) {
            VarElementCountSequenceTypeImpl varElementCountSequenceTypeImpl = this;
            synchronized (varElementCountSequenceTypeImpl) {
                if (this.memberIndex == -1 && parent instanceof CompoundData) {
                    CompoundData compoundData = (CompoundData)parent;
                    this.memberIndex = compoundData.getType().getMemberIndex(this.memberName);
                }
            }
            if (this.memberIndex == -1) {
                throw new IllegalArgumentException("parent");
            }
        }
        return parent.getInt(this.memberIndex);
    }
}

