/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractSequence;
import com.bc.ceres.binio.internal.CollectionInstance;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.FixCompound;
import com.bc.ceres.binio.internal.FixSequenceOfFixCollections;
import com.bc.ceres.binio.internal.FixSequenceOfSimples;
import com.bc.ceres.binio.internal.FixSequenceOfVarCollections;
import com.bc.ceres.binio.internal.MemberInstance;
import com.bc.ceres.binio.internal.Segment;
import com.bc.ceres.binio.internal.SequenceInstance;
import com.bc.ceres.binio.internal.SimpleMember;
import com.bc.ceres.binio.internal.VarCompound;
import com.bc.ceres.binio.internal.VarSequenceOfFixCollections;
import com.bc.ceres.binio.internal.VarSequenceOfSimples;
import java.io.IOException;
import java.nio.ByteOrder;

public class InstanceFactory {
    public static CompoundInstance createCompound(DataContext context, CollectionData parent, CompoundType compoundType, long position, ByteOrder byteOrder) {
        if (compoundType.isSizeKnown()) {
            return new FixCompound(context, parent, compoundType, position);
        }
        return new VarCompound(context, parent, compoundType, position);
    }

    static SequenceInstance createSequence(DataContext context, CollectionData parent, SequenceType sequenceType, long position, ByteOrder byteOrder) {
        Type elementType = sequenceType.getElementType();
        if (elementType.isSimpleType()) {
            if (sequenceType.getElementCount() >= 0) {
                return new FixSequenceOfSimples(context, parent, sequenceType, position);
            }
            return new VarSequenceOfSimples(context, parent, sequenceType, position);
        }
        if (elementType.isSizeKnown()) {
            if (sequenceType.getElementCount() >= 0) {
                return new FixSequenceOfFixCollections(context, parent, sequenceType, position);
            }
            return new VarSequenceOfFixCollections(context, parent, sequenceType, position);
        }
        if (sequenceType.getElementCount() >= 0) {
            return new FixSequenceOfVarCollections(context, parent, sequenceType, position);
        }
        throw new IllegalArgumentException("unsupported sequence type: " + sequenceType);
    }

    static CollectionInstance createCollection(DataContext context, CollectionData parent, Type type, long position, ByteOrder byteOrder) throws IOException {
        if (type.isCompoundType()) {
            return InstanceFactory.createCompound(context, parent, (CompoundType)type, position, byteOrder);
        }
        if (type.isSequenceType()) {
            return InstanceFactory.createSequence(context, parent, AbstractSequence.resolveSequenceType(parent, (SequenceType)type), position, byteOrder);
        }
        throw new IllegalArgumentException("illegal type: " + type);
    }

    static MemberInstance createMember(DataContext context, CompoundData parent, Type type, long position, ByteOrder byteOrder) throws IOException {
        if (type.isSimpleType()) {
            return InstanceFactory.createFixMember(context, parent, type, new Segment(position, type.getSize()), 0);
        }
        return InstanceFactory.createCollection(context, parent, type, position, byteOrder);
    }

    static MemberInstance createFixMember(DataContext context, CollectionData parent, Type type, Segment segment, int segmentOffset) {
        if (!type.isSizeKnown()) {
            throw new IllegalArgumentException("illegal type: " + type);
        }
        if (type.isSimpleType()) {
            return new SimpleMember(context, parent, (SimpleType)type, segment, segmentOffset);
        }
        if (type.isSequenceType()) {
            return InstanceFactory.createFixSequence(context, parent, (SequenceType)type, segment, segmentOffset);
        }
        if (type.isCompoundType()) {
            return InstanceFactory.createFixCompound(context, parent, (CompoundType)type, segment, segmentOffset);
        }
        throw new IllegalArgumentException("illegal type: " + type);
    }

    static CompoundInstance createFixCompound(DataContext context, CollectionData parent, CompoundType compoundType, Segment segment, int segmentOffset) {
        return new FixCompound(context, parent, compoundType, segment, segmentOffset);
    }

    static SequenceInstance createFixSequence(DataContext context, CollectionData parent, SequenceType sequenceType, Segment segment, int segmentOffset) {
        Type elementType = sequenceType.getElementType();
        if (elementType.isSimpleType()) {
            return new FixSequenceOfSimples(context, parent, sequenceType, segment, segmentOffset);
        }
        return new FixSequenceOfFixCollections(context, parent, sequenceType, segment, segmentOffset);
    }

    private InstanceFactory() {
    }
}

