/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductWriter;
import org.esa.snap.dataio.bigtiff.Constants;

public class BigGeoTiffProductWriterPlugIn
implements ProductWriterPlugIn {
    public static final String FORMAT_NAME = "GeoTIFF-BigTIFF";
    private static final Class[] OUTPUT_TYPES = new Class[]{String.class, File.class};

    public EncodeQualification getEncodeQualification(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return new EncodeQualification(EncodeQualification.Preservation.PARTIAL, "The product is not geo-coded. A usual TIFF file will be written instead.");
        }
        if (!(geoCoding instanceof MapGeoCoding) && !(geoCoding instanceof CrsGeoCoding)) {
            return new EncodeQualification(EncodeQualification.Preservation.PARTIAL, "The product is geo-coded but seems not rectified. Geo-coding information may not be properly preserved.");
        }
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return new EncodeQualification(EncodeQualification.Preservation.FULL);
    }

    public Class[] getOutputTypes() {
        return OUTPUT_TYPES;
    }

    public ProductWriter createWriterInstance() {
        return new BigGeoTiffProductWriter(this);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return Constants.FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return "GeoTIFF / BigTIFF data product";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

