/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import it.geosolutions.imageio.plugins.tiff.TIFFCompressor;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFImageWriteParam;
import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFIFD;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriter;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFLZWCompressor;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.operator.FormatDescriptor;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.dataio.dimap.DimapHeaderWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.geotiff.GeoTIFF;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.bigtiff.Constants;
import org.esa.snap.dataio.bigtiff.internal.TiffIFD;
import org.esa.snap.runtime.Config;

class BigGeoTiffProductWriter
extends AbstractProductWriter {
    private static String PARAM_COMPRESSION_TYPE = "snap.dataio.bigtiff.compression.type";
    private static String PARAM_COMPRESSION_QUALITY = "snap.dataio.bigtiff.compression.quality";
    private static float PARAM_COMPRESSION_QUALITY_DEFAULT = 0.75f;
    private static String PARAM_TILING_WIDTH = "snap.dataio.bigtiff.tiling.width";
    private static String PARAM_TILING_HEIGHT = "snap.dataio.bigtiff.tiling.height";
    private static String PARAM_FORCE_BIGTIFF = "snap.dataio.bigtiff.force.bigtiff";
    private File outputFile;
    private TIFFImageWriter imageWriter;
    private boolean isWritten;
    private FileImageOutputStream outputStream;
    private TIFFImageWriteParam writeParam;

    public BigGeoTiffProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
        this.createWriterParams();
    }

    private void createWriterParams() {
        this.writeParam = new TIFFImageWriteParam(Locale.ENGLISH);
        String compressionType = Config.instance().preferences().get(PARAM_COMPRESSION_TYPE, null);
        if (StringUtils.isNotNullAndNotEmpty((String)compressionType)) {
            if (compressionType.equals("LZW")) {
                this.writeParam.setCompressionMode(2);
                TIFFLZWCompressor compressor = new TIFFLZWCompressor(1);
                this.writeParam.setTIFFCompressor((TIFFCompressor)compressor);
                this.writeParam.setCompressionType(compressor.getCompressionType());
                float compressionQuality = Config.instance().preferences().getFloat(PARAM_COMPRESSION_QUALITY, PARAM_COMPRESSION_QUALITY_DEFAULT);
                this.writeParam.setCompressionQuality(compressionQuality);
            } else {
                throw new IllegalArgumentException("Compression type '" + compressionType + "' is not supported");
            }
        }
        String tilingWidthProperty = Config.instance().preferences().get(PARAM_TILING_WIDTH, null);
        String tilingHeightProperty = Config.instance().preferences().get(PARAM_TILING_HEIGHT, null);
        if (StringUtils.isNotNullAndNotEmpty((String)tilingWidthProperty) && StringUtils.isNotNullAndNotEmpty((String)tilingHeightProperty)) {
            int tileWidth = Integer.parseInt(tilingWidthProperty);
            int tileHeight = Integer.parseInt(tilingHeightProperty);
            this.writeParam.setTilingMode(2);
            this.writeParam.setTiling(tileWidth, tileHeight, 0, 0);
        }
        boolean forceBigTiff = Config.instance().preferences().getBoolean(PARAM_FORCE_BIGTIFF, false);
        this.writeParam.setForceToBigTIFF(forceBigTiff);
    }

    protected void writeProductNodesImpl() throws IOException {
        this.outputFile = null;
        File file = this.getOutput() instanceof String ? new File((String)this.getOutput()) : (File)this.getOutput();
        this.outputFile = FileUtils.ensureExtension((File)file, (String)Constants.FILE_EXTENSIONS[0]);
        this.deleteOutput();
        this.updateProductName();
        this.updateTilingParameter();
        this.imageWriter = this.getTiffImageWriter();
        this.outputStream = new FileImageOutputStream(this.outputFile);
        this.imageWriter.setOutput((Object)this.outputStream);
    }

    private void updateTilingParameter() {
        if (this.writeParam.getTilingMode() != 2) {
            Product sourceProduct = this.getSourceProduct();
            MultiLevelImage firstSourceImage = sourceProduct.getBandAt(0).getSourceImage();
            int tileWidth = firstSourceImage.getTileWidth();
            int tileHeight = firstSourceImage.getTileHeight();
            this.writeParam.setTilingMode(2);
            this.writeParam.setTiling(tileWidth, tileHeight, 0, 0);
        }
    }

    private TIFFImageWriter getTiffImageWriter() {
        Iterator<ImageWriter> writerIterator = ImageIO.getImageWritersByFormatName("TIFF");
        while (writerIterator.hasNext()) {
            ImageWriter writer = writerIterator.next();
            if (!(writer instanceof TIFFImageWriter)) continue;
            return (TIFFImageWriter)writer;
        }
        throw new IllegalStateException("No appropriate image writer for format BigTIFF found.");
    }

    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        RenderedImage writeImage;
        if (this.isWritten) {
            return;
        }
        Product sourceProduct = sourceBand.getProduct();
        int targetDataType = this.getTargetDataType(sourceProduct);
        ArrayList<Band> bandsToExport = this.getBandsToExport(sourceProduct);
        if (bandsToExport.size() > 1) {
            ParameterBlock parameterBlock = new ParameterBlock();
            for (int i = 0; i < bandsToExport.size(); ++i) {
                Band subsetBand = bandsToExport.get(i);
                RenderedImage sourceImage = this.getImageWithTargetDataType(targetDataType, subsetBand);
                parameterBlock.setSource(sourceImage, i);
            }
            writeImage = JAI.create((String)"bandmerge", (ParameterBlock)parameterBlock, null);
        } else {
            writeImage = this.getImageWithTargetDataType(targetDataType, bandsToExport.get(0));
        }
        GeoTIFFMetadata geoTIFFMetadata = ProductUtils.createGeoTIFFMetadata((Product)sourceProduct);
        if (geoTIFFMetadata == null) {
            geoTIFFMetadata = new GeoTIFFMetadata();
        }
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(writeImage);
        TIFFImageMetadata iioMetadata = (TIFFImageMetadata)GeoTIFF.createIIOMetadata((ImageWriter)this.imageWriter, (ImageTypeSpecifier)imageTypeSpecifier, (GeoTIFFMetadata)geoTIFFMetadata, (String)"it_geosolutions_imageioimpl_plugins_tiff_image_1.0", (String)"it.geosolutions.imageio.plugins.tiff.BaselineTIFFTagSet,it.geosolutions.imageio.plugins.tiff.BaselineTIFFTagSet");
        this.addDimapMetaField(sourceProduct, iioMetadata);
        SampleModel sampleModel = writeImage.getSampleModel();
        this.writeParam.setDestinationType(new ImageTypeSpecifier(new BogusAndCheatingColorModel(sampleModel), sampleModel));
        IIOImage iioImage = new IIOImage(writeImage, null, (IIOMetadata)iioMetadata);
        this.imageWriter.write(null, iioImage, (ImageWriteParam)this.writeParam);
        this.isWritten = true;
    }

    private ArrayList<Band> getBandsToExport(Product sourceProduct) {
        int nodeCount = sourceProduct.getNumBands();
        ArrayList<Band> bandsToWrite = new ArrayList<Band>();
        for (int i = 0; i < nodeCount; ++i) {
            Band band = sourceProduct.getBandAt(i);
            if (!this.shouldWrite((ProductNode)band)) continue;
            bandsToWrite.add(band);
        }
        return bandsToWrite;
    }

    private int getTargetDataType(Product sourceProduct) {
        TiffIFD tiffIFD = new TiffIFD(sourceProduct);
        int maxSourceDataType = tiffIFD.getBandDataType();
        return ImageManager.getDataBufferType((int)maxSourceDataType);
    }

    private void addDimapMetaField(Product sourceProduct, TIFFImageMetadata iioMetadata) {
        TIFFTag beamMetaTag = new TIFFTag("BEAM_METADATA", 65000, 2);
        String beamMetadata = this.getBeamMetadata(sourceProduct);
        TIFFIFD rootIFD = iioMetadata.getRootIFD();
        TIFFField beamMetaDataTiffField = new TIFFField(beamMetaTag, 2, 1, (Object)new String[]{beamMetadata});
        rootIFD.addTIFFField(beamMetaDataTiffField);
    }

    private String getBeamMetadata(Product product) {
        StringWriter stringWriter = new StringWriter();
        DimapHeaderWriter writer = new DimapHeaderWriter(product, (Writer)stringWriter, "");
        writer.writeHeader();
        writer.close();
        return stringWriter.getBuffer().toString();
    }

    private RenderedImage getImageWithTargetDataType(int targetDataType, Band subsetBand) {
        MultiLevelImage sourceImage = subsetBand.getSourceImage();
        int actualTargetBandDataType = sourceImage.getSampleModel().getDataType();
        if (actualTargetBandDataType != targetDataType) {
            sourceImage = FormatDescriptor.create((RenderedImage)sourceImage, (Integer)targetDataType, null);
        }
        return sourceImage;
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.imageWriter != null) {
            this.imageWriter.dispose();
            this.imageWriter = null;
        }
    }

    public boolean shouldWrite(ProductNode node) {
        if (node instanceof VirtualBand) {
            return false;
        }
        return !(node instanceof FilterBand);
    }

    public void deleteOutput() throws IOException {
        if (this.outputFile != null && this.outputFile.isFile() && !this.outputFile.delete()) {
            throw new IOException("Unable to delete file: " + this.outputFile.getAbsolutePath());
        }
    }

    private void updateProductName() {
        if (this.outputFile != null) {
            this.getSourceProduct().setName(FileUtils.getFilenameWithoutExtension((File)this.outputFile));
        }
    }

    private static class BogusAndCheatingColorModel
    extends ColorModel {
        private SampleModel sampleModel;

        public BogusAndCheatingColorModel(SampleModel sampleModel) {
            super(8, new int[]{8}, ColorSpace.getInstance(1003), false, false, 1, 0);
            this.sampleModel = sampleModel;
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            return this.isCompatibleSampleModel(raster.getSampleModel());
        }

        @Override
        public boolean isCompatibleSampleModel(SampleModel sm) {
            return this.sampleModel.getNumBands() == sm.getNumBands() && this.sampleModel.getDataType() == sm.getDataType();
        }

        @Override
        public int getNumComponents() {
            return this.sampleModel.getNumBands();
        }

        @Override
        public int getRed(int pixel) {
            return 0;
        }

        @Override
        public int getGreen(int pixel) {
            return 0;
        }

        @Override
        public int getBlue(int pixel) {
            return 0;
        }

        @Override
        public int getAlpha(int pixel) {
            return 0;
        }
    }
}

