/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductReader;
import org.esa.snap.dataio.bigtiff.Constants;

public class BigGeoTiffProductReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "GeoTIFF-BigTIFF";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecodeQualification getDecodeQualification(Object input) {
        try {
            Object imageIOInput;
            if (input instanceof String) {
                imageIOInput = new File((String)input);
            } else {
                if (!(input instanceof File)) {
                    if (!(input instanceof InputStream)) return DecodeQualification.UNABLE;
                }
                imageIOInput = input;
            }
            try (ImageInputStream stream = ImageIO.createImageInputStream(imageIOInput);){
                DecodeQualification decodeQualification = BigGeoTiffProductReaderPlugIn.getDecodeQualificationImpl(stream);
                return decodeQualification;
            }
        }
        catch (Exception exception) {
            return DecodeQualification.UNABLE;
        }
    }

    public ProductReader createReaderInstance() {
        return new BigGeoTiffProductReader(this);
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, InputStream.class};
    }

    public String[] getFormatNames() {
        return Constants.FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return Constants.FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return "GeoTIFF / BigTIFF data product";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(Constants.FORMAT_NAMES[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    static DecodeQualification getDecodeQualificationImpl(ImageInputStream stream) {
        try {
            TIFFImageReader imageReader = BigGeoTiffProductReaderPlugIn.getTiffImageReader(stream);
            if (imageReader == null) {
                return DecodeQualification.UNABLE;
            }
        }
        catch (Exception ignore) {
            return DecodeQualification.UNABLE;
        }
        return DecodeQualification.SUITABLE;
    }

    static TIFFImageReader getTiffImageReader(ImageInputStream stream) {
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        TIFFImageReader imageReader = null;
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (!(reader instanceof TIFFImageReader)) continue;
            imageReader = (TIFFImageReader)reader;
            break;
        }
        return imageReader;
    }
}

