/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import org.esa.snap.dataio.bigtiff.internal.GeoTiffAscii;
import org.esa.snap.dataio.bigtiff.internal.TiffAscii;
import org.esa.snap.dataio.bigtiff.internal.TiffDouble;
import org.esa.snap.dataio.bigtiff.internal.TiffLong;
import org.esa.snap.dataio.bigtiff.internal.TiffRational;
import org.esa.snap.dataio.bigtiff.internal.TiffShort;
import org.esa.snap.dataio.bigtiff.internal.TiffType;
import org.esa.snap.dataio.bigtiff.internal.TiffUInt;
import org.esa.snap.dataio.bigtiff.internal.TiffValue;
import org.junit.Assert;
import org.junit.Test;

public class TiffTypeTest {
    @Test
    public void testGetType_nullInput() {
        try {
            TiffType.getType(null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetType_zeroLengthInput() {
        try {
            TiffType.getType((TiffValue[])new TiffValue[0]);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetType_elementsAreNull() {
        try {
            TiffType.getType((TiffValue[])new TiffValue[2]);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetType() {
        TiffValue[] array = new TiffValue[]{new TiffShort(1)};
        TiffShort type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)3L, (long)type.getValue());
        array[0] = new TiffUInt(2L);
        type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)4L, (long)type.getValue());
        array[0] = new TiffRational(3L, 4L);
        type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)5L, (long)type.getValue());
        array[0] = new TiffAscii(new String[]{"bla"});
        type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)2L, (long)type.getValue());
        array[0] = new GeoTiffAscii(new String[]{"blubb"});
        type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)2L, (long)type.getValue());
        array[0] = new TiffDouble(5.6);
        type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)12L, (long)type.getValue());
        array[0] = new TiffLong(7L);
        type = TiffType.getType((TiffValue[])array);
        Assert.assertEquals((long)17L, (long)type.getValue());
    }
}

