/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.snap.dataio.bigtiff.internal.TiffLong;
import org.junit.Assert;
import org.junit.Test;

public class TiffLongTest {
    @Test
    public void testConstructAndGetData() {
        TiffLong tiffLong = new TiffLong(12345678910L);
        Assert.assertEquals((long)12345678910L, (long)tiffLong.getValue());
    }

    @Test
    public void testGetSizeInBytes() {
        TiffLong tiffLong = new TiffLong(13L);
        Assert.assertEquals((long)8L, (long)tiffLong.getSizeInBytes());
    }

    @Test
    public void testWrite() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
        TiffLong tiffLong = new TiffLong(23345L);
        tiffLong.write((ImageOutputStream)stream);
        stream.close();
        Assert.assertEquals((long)8L, (long)byteArrayOutputStream.toString().length());
    }
}

