/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.bigtiff.internal.TiffIFD;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TiffId_dataTypeTest {
    private Product product;

    @Before
    public void setUp() {
        this.product = new Product("bla", "bla", 3, 3);
    }

    @Test
    public void testGetBandDataType_int8() {
        this.product.addBand("signed", 10);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)10L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_uint8() {
        this.product.addBand("unsigned", 20);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)20L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_mixed_8bits() {
        this.product.addBand("signed", 10);
        this.product.addBand("usigned", 20);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)11L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_int16() {
        this.product.addBand("signed", 11);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)11L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_uint16() {
        this.product.addBand("unsigned", 21);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)21L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_mixed_16bits() {
        this.product.addBand("signed", 11);
        this.product.addBand("unsigned", 21);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)12L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_int32() {
        this.product.addBand("signed", 12);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)12L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_uint32() {
        this.product.addBand("unsigned", 22);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)22L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_mixed_32bits() {
        this.product.addBand("signed", 12);
        this.product.addBand("unsigned", 22);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)31L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_float32() {
        this.product.addBand("single", 30);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)30L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_float64() {
        this.product.addBand("double", 31);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)31L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_mixed_floatTypes() {
        this.product.addBand("single", 30);
        this.product.addBand("double", 31);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)31L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_mixed_integerTypes() {
        this.product.addBand("one", 20);
        this.product.addBand("two", 12);
        this.product.addBand("double", 11);
        this.product.addBand("three", 11);
        this.product.addBand("four", 21);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)12L, (long)tiffIFD.getBandDataType());
    }

    @Test
    public void testGetBandDataType_mixed_integerAndFloatTypes() {
        this.product.addBand("one", 20);
        this.product.addBand("two", 30);
        this.product.addBand("double", 11);
        this.product.addBand("three", 12);
        this.product.addBand("four", 21);
        TiffIFD tiffIFD = new TiffIFD(this.product);
        Assert.assertEquals((long)31L, (long)tiffIFD.getBandDataType());
    }
}

