/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import java.io.File;
import org.esa.snap.dataio.bigtiff.internal.GeoKeyEntry;
import org.junit.Assert;
import org.junit.Test;

public class GeoKeyEntryTest {
    @Test
    public void testConstructAndGet_Integer() {
        GeoKeyEntry entry = new GeoKeyEntry(3072, 9, 1, (Object)89);
        Assert.assertEquals((long)89L, (long)entry.getIntValue().intValue());
        Assert.assertEquals((long)3072L, (long)entry.getKeyId());
        Assert.assertEquals((Object)"ProjectedCSTypeGeoKey", (Object)entry.getName());
        Assert.assertTrue((boolean)entry.hasIntValue());
        Assert.assertFalse((boolean)entry.hasStringValue());
        Assert.assertFalse((boolean)entry.hasDoubleValues());
    }

    @Test
    public void testConstructAndGet_String() {
        GeoKeyEntry entry = new GeoKeyEntry(3073, 10, 1, (Object)"theTestValue");
        Assert.assertEquals((Object)"theTestValue", (Object)entry.getStringValue());
        Assert.assertEquals((long)3073L, (long)entry.getKeyId());
        Assert.assertEquals((Object)"PCSCitationGeoKey", (Object)entry.getName());
        Assert.assertFalse((boolean)entry.hasIntValue());
        Assert.assertTrue((boolean)entry.hasStringValue());
        Assert.assertFalse((boolean)entry.hasDoubleValues());
    }

    @Test
    public void testConstructAndGet_DoubleArray() {
        GeoKeyEntry entry = new GeoKeyEntry(3074, 11, 3, (Object)new double[]{1.0, 2.0, 3.0});
        double[] values = entry.getDoubleValues();
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0}, (double[])values, (double)1.0E-8);
        Assert.assertEquals((long)3074L, (long)entry.getKeyId());
        Assert.assertEquals((Object)"ProjectionGeoKey", (Object)entry.getName());
        Assert.assertFalse((boolean)entry.hasIntValue());
        Assert.assertFalse((boolean)entry.hasStringValue());
        Assert.assertTrue((boolean)entry.hasDoubleValues());
    }

    @Test
    public void testConstruct_unsupportedType() {
        try {
            new GeoKeyEntry(3074, 12, 2, (Object)new File("."));
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

