/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductWriter;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductWriterPlugIn;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BigGeoTiffProductWriterPlugInTest {
    private BigGeoTiffProductWriterPlugIn plugIn;

    @Before
    public void setUp() {
        this.plugIn = new BigGeoTiffProductWriterPlugIn();
    }

    @Test
    public void testGetFormatNames() {
        Object[] formatNames = this.plugIn.getFormatNames();
        Assert.assertArrayEquals((Object[])new String[]{"GeoTIFF-BigTIFF"}, (Object[])formatNames);
    }

    @Test
    public void testGetDefaultFileExtensions() {
        Object[] defaultFileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertArrayEquals((Object[])new String[]{".tif", ".tiff"}, (Object[])defaultFileExtensions);
    }

    @Test
    public void testGetOutputTypes() {
        Object[] outputTypes = this.plugIn.getOutputTypes();
        Assert.assertArrayEquals((Object[])new Class[]{String.class, File.class}, (Object[])outputTypes);
    }

    @Test
    public void testGetDescription() {
        Assert.assertNotNull((Object)this.plugIn.getDescription(null));
    }

    @Test
    public void testProductFileFilter() {
        SnapFileFilter snapFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)snapFileFilter);
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])snapFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)snapFileFilter.getFormatName());
        Assert.assertEquals((Object)true, (Object)snapFileFilter.getDescription().contains(this.plugIn.getDescription(Locale.getDefault())));
    }

    @Test
    public void testCreateWriterInstance() {
        ProductWriter writer = this.plugIn.createWriterInstance();
        Assert.assertNotNull((Object)writer);
        Assert.assertTrue((boolean)(writer instanceof BigGeoTiffProductWriter));
    }

    @Test
    public void testEncodingQualification() throws Exception {
        Product product = new Product("N", "T", 2, 2);
        EncodeQualification encodeQualification = this.plugIn.getEncodeQualification(product);
        Assert.assertNotNull((Object)encodeQualification);
        Assert.assertEquals((Object)EncodeQualification.Preservation.PARTIAL, (Object)encodeQualification.getPreservation());
        Assert.assertNotNull((Object)encodeQualification.getInfoString());
        TiePointGrid lat = new TiePointGrid("lat", 2, 2, 0.0, 0.0, 1.0, 1.0, new float[4]);
        TiePointGrid lon = new TiePointGrid("lon", 2, 2, 0.0, 0.0, 1.0, 1.0, new float[4]);
        product.addTiePointGrid(lat);
        product.addTiePointGrid(lon);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(lat, lon));
        encodeQualification = this.plugIn.getEncodeQualification(product);
        Assert.assertEquals((Object)EncodeQualification.Preservation.PARTIAL, (Object)encodeQualification.getPreservation());
        Assert.assertNotNull((Object)encodeQualification.getInfoString());
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 2, 2, 0.0, 0.0, 1.0, 1.0));
        encodeQualification = this.plugIn.getEncodeQualification(product);
        Assert.assertEquals((Object)EncodeQualification.Preservation.FULL, (Object)encodeQualification.getPreservation());
    }
}

