/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.IOException;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductReader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BigGeoTiffProductReaderTest {
    @Test
    public void testIsAsciiField_isAscii() {
        TIFFField field = this.getTiffField(2, null);
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isAsciiField((TIFFField)field));
    }

    @Test
    public void testIsAsciiField_null() {
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isAsciiField(null));
    }

    @Test
    public void testIsAsciiField_notAscii() {
        TIFFField field = this.getTiffField(12, null);
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isAsciiField((TIFFField)field));
    }

    @Test
    public void testIsDimapField_null() {
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isDimapField(null));
    }

    @Test
    public void testIsDimapField_isDimap() {
        TIFFField field = this.getTiffField(2, new String[]{"<Dimap_Document> blabla"});
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isDimapField((TIFFField)field));
    }

    @Test
    public void testIsDimapField_notDimap() {
        TIFFField field = this.getTiffField(2, new String[]{"<Strange_tag> blabla"});
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isDimapField((TIFFField)field));
    }

    @Test
    public void testIBadTiling_goodTiling() throws IOException {
        TIFFImageReader reader = (TIFFImageReader)Mockito.mock(TIFFImageReader.class);
        Mockito.when((Object)reader.getHeight(0)).thenReturn((Object)20);
        Mockito.when((Object)reader.getWidth(0)).thenReturn((Object)40);
        Mockito.when((Object)reader.getTileHeight(0)).thenReturn((Object)10);
        Mockito.when((Object)reader.getTileWidth(0)).thenReturn((Object)20);
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isBadTiling((TIFFImageReader)reader));
        Mockito.when((Object)reader.getHeight(0)).thenReturn((Object)8000);
        Mockito.when((Object)reader.getWidth(0)).thenReturn((Object)2756);
        Mockito.when((Object)reader.getTileHeight(0)).thenReturn((Object)199);
        Mockito.when((Object)reader.getTileWidth(0)).thenReturn((Object)287);
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isBadTiling((TIFFImageReader)reader));
    }

    @Test
    public void testIBadTiling_badTiling() throws IOException {
        TIFFImageReader reader = (TIFFImageReader)Mockito.mock(TIFFImageReader.class);
        Mockito.when((Object)reader.getHeight(0)).thenReturn((Object)20);
        Mockito.when((Object)reader.getWidth(0)).thenReturn((Object)40);
        Mockito.when((Object)reader.getTileHeight(0)).thenReturn((Object)1);
        Mockito.when((Object)reader.getTileWidth(0)).thenReturn((Object)20);
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isBadTiling((TIFFImageReader)reader));
        Mockito.when((Object)reader.getHeight(0)).thenReturn((Object)20);
        Mockito.when((Object)reader.getWidth(0)).thenReturn((Object)40);
        Mockito.when((Object)reader.getTileHeight(0)).thenReturn((Object)10);
        Mockito.when((Object)reader.getTileWidth(0)).thenReturn((Object)1);
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isBadTiling((TIFFImageReader)reader));
        Mockito.when((Object)reader.getHeight(0)).thenReturn((Object)20);
        Mockito.when((Object)reader.getWidth(0)).thenReturn((Object)40);
        Mockito.when((Object)reader.getTileHeight(0)).thenReturn((Object)20);
        Mockito.when((Object)reader.getTileWidth(0)).thenReturn((Object)20);
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isBadTiling((TIFFImageReader)reader));
        Mockito.when((Object)reader.getHeight(0)).thenReturn((Object)20);
        Mockito.when((Object)reader.getWidth(0)).thenReturn((Object)40);
        Mockito.when((Object)reader.getTileHeight(0)).thenReturn((Object)10);
        Mockito.when((Object)reader.getTileWidth(0)).thenReturn((Object)40);
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isBadTiling((TIFFImageReader)reader));
    }

    @Test
    public void testIsPixelScaleValid() {
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isPixelScaleValid(null));
        double[] scales = new double[]{Double.NaN, 9.1};
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isPixelScaleValid((double[])scales));
        scales[0] = 9.2;
        scales[1] = Double.NaN;
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isPixelScaleValid((double[])scales));
        scales[0] = Double.NEGATIVE_INFINITY;
        scales[1] = 9.3;
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isPixelScaleValid((double[])scales));
        scales[0] = 9.4;
        scales[1] = Double.POSITIVE_INFINITY;
        Assert.assertFalse((boolean)BigGeoTiffProductReader.isPixelScaleValid((double[])scales));
        scales[0] = 9.5;
        scales[1] = 9.6;
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isPixelScaleValid((double[])scales));
        scales[0] = -9.7;
        scales[1] = 0.0;
        Assert.assertTrue((boolean)BigGeoTiffProductReader.isPixelScaleValid((double[])scales));
    }

    private TIFFField getTiffField(int type, Object data) {
        TIFFTag tag = new TIFFTag("test", 1, type);
        if (data != null) {
            return new TIFFField(tag, type, 1, data);
        }
        return new TIFFField(tag, type, 1);
    }
}

