/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductReader;
import org.esa.snap.dataio.bigtiff.BigGeoTiffProductReaderPlugIn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BigGeoTiffProductReaderPlugInTest {
    private BigGeoTiffProductReaderPlugIn plugIn;

    @Before
    public void setUp() {
        this.plugIn = new BigGeoTiffProductReaderPlugIn();
    }

    @Test
    public void testGetInputTypes() {
        Class[] inputTypes = this.plugIn.getInputTypes();
        Assert.assertNotNull((Object)inputTypes);
        Assert.assertEquals((long)3L, (long)inputTypes.length);
        Assert.assertEquals(String.class, (Object)inputTypes[0]);
        Assert.assertEquals(File.class, (Object)inputTypes[1]);
        Assert.assertEquals(InputStream.class, (Object)inputTypes[2]);
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader reader = this.plugIn.createReaderInstance();
        Assert.assertNotNull((Object)reader);
        Assert.assertTrue((boolean)(reader instanceof BigGeoTiffProductReader));
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"GeoTIFF-BigTIFF", (Object)formatNames[0]);
    }

    @Test
    public void testGetDefaultFileExtensions() {
        String[] defaultFileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertEquals((long)2L, (long)defaultFileExtensions.length);
        Assert.assertEquals((Object)".tif", (Object)defaultFileExtensions[0]);
        Assert.assertEquals((Object)".tiff", (Object)defaultFileExtensions[1]);
    }

    @Test
    public void testGetDescription() {
        String description = this.plugIn.getDescription(null);
        Assert.assertNotNull((Object)description);
    }

    @Test
    public void testProductFileFilter() {
        SnapFileFilter snapFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)snapFileFilter);
        Assert.assertArrayEquals((Object[])this.plugIn.getDefaultFileExtensions(), (Object[])snapFileFilter.getExtensions());
        Assert.assertEquals((Object)this.plugIn.getFormatNames()[0], (Object)snapFileFilter.getFormatName());
        Assert.assertEquals((Object)true, (Object)snapFileFilter.getDescription().contains(this.plugIn.getDescription(Locale.getDefault())));
    }
}

